<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charges StructType
 * Meta informations extracted from the WSDL
 * - documentation: A container for any additional charges to the cost of the insurance plan.
 * @subpackage Structs
 */
class Charges extends AbstractStructBase
{
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - documentation: Contains a description and value of a single additional charge to the cost of the plan.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Charge;
    /**
     * Constructor method for Charges
     * @uses Charges::setCharge()
     * @param mixed[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * @return mixed[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param mixed[] $charge
     * @return \StructType\Charges
     */
    public function setCharge(array $charge = array())
    {
        foreach ($charge as $chargesChargeItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of anyType, "%s" given', is_object($chargesChargeItem) ? get_class($chargesChargeItem) : gettype($chargesChargeItem)), __LINE__);
            }
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Charges
     */
    public function addToCharge($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Charges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
