<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClass StructType
 * Meta informations extracted from the WSDL
 * - documentation: if the seat map display is to be requested for a specific cabin class , the cabin class can be specified in this element. | if the meal display is to be requested for a specific cabin class , the cabin class can be specified in this
 * element. | if the ssr display is to be requested for a specific cabin class , the cabin class can be specified in this element. | if the baggage display is to be requested for a specific cabin class , the cabin class can be specified in this element.
 * @subpackage Structs
 */
class CabinClass extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta informations extracted from the WSDL
     * - documentation: cabin type for which the seat map is requested, which could be either First, Business or Economy | cabin type for which the meal details are requested, which could be either First, Business or Economy | cabin type for which the ssr
     * details are requested, which could be either First, Business or Economy | cabin type for which the baggage details are requested, which could be either First, Business or Economy
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * Constructor method for CabinClass
     * @uses CabinClass::setCabinType()
     * @param string $cabinType
     */
    public function __construct($cabinType = null)
    {
        $this
            ->setCabinType($cabinType);
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\CabinClass
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinType, implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClass
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
