<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingPriceInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for all the fare information. | Pricing information for an itinerary.
 * @subpackage Structs
 */
class BookingPriceInfoType extends AirItineraryPricingInfoType
{
    /**
     * The PriceRequestInformation
     * Meta informations extracted from the WSDL
     * - documentation: Identifies pricing source, if negotiated fares are requested and if it is a reprice request.
     * - minOccurs: 0
     * @var mixed
     */
    public $PriceRequestInformation;
    /**
     * The RepriceRequired
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: If true re-pricing of the itinerary is required.
     * @var bool
     */
    public $RepriceRequired;
    /**
     * Constructor method for BookingPriceInfoType
     * @uses BookingPriceInfoType::setPriceRequestInformation()
     * @uses BookingPriceInfoType::setRepriceRequired()
     * @param mixed $priceRequestInformation
     * @param bool $repriceRequired
     */
    public function __construct($priceRequestInformation = null, $repriceRequired = false)
    {
        $this
            ->setPriceRequestInformation($priceRequestInformation)
            ->setRepriceRequired($repriceRequired);
    }
    /**
     * Get PriceRequestInformation value
     * @return mixed|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param mixed $priceRequestInformation
     * @return \StructType\BookingPriceInfoType
     */
    public function setPriceRequestInformation($priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Get RepriceRequired value
     * @return bool|null
     */
    public function getRepriceRequired()
    {
        return $this->RepriceRequired;
    }
    /**
     * Set RepriceRequired value
     * @param bool $repriceRequired
     * @return \StructType\BookingPriceInfoType
     */
    public function setRepriceRequired($repriceRequired = false)
    {
        // validation for constraint: boolean
        if (!is_null($repriceRequired) && !is_bool($repriceRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($repriceRequired)), __LINE__);
        }
        $this->RepriceRequired = $repriceRequired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingPriceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
