<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookFlightSegmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for the flight segment data plus the MarriageGrp. | Construct for holding the booked flight segment information.
 * @subpackage Structs
 */
class BookFlightSegmentType extends FlightSegmentType
{
    /**
     * The MarriageGrp
     * Meta informations extracted from the WSDL
     * - documentation: Many airlines link connection flights together by terming them married segments. When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of
     * the marriage group must be the same for all segments.
     * - minOccurs: 0
     * @var mixed
     */
    public $MarriageGrp;
    /**
     * The BookingClassAvails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingClassAvails
     */
    public $BookingClassAvails;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Free text information that the marketing carrier may send about this flight.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Comment;
    /**
     * The AvailableFlexiOperations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AvailableFlexiOperations
     */
    public $AvailableFlexiOperations;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: Specific Booking Class for this segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ResCabinClass
     * Meta informations extracted from the WSDL
     * - documentation: Specific Cabin Class for this segment.
     * - use: optional
     * @var string
     */
    public $ResCabinClass;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: Number of travelers associated with this segment.
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Code providing status information for this segment. Refer to OTA Code List 'Status' (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The E_TicketEligibility
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $E_TicketEligibility;
    /**
     * The MealCode
     * Meta informations extracted from the WSDL
     * - documentation: The applicable meal service code for this flight.
     * - use: optional
     * @var string
     */
    public $MealCode;
    /**
     * The DepartureDay
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DepartureDay;
    /**
     * Constructor method for BookFlightSegmentType
     * @uses BookFlightSegmentType::setMarriageGrp()
     * @uses BookFlightSegmentType::setBookingClassAvails()
     * @uses BookFlightSegmentType::setComment()
     * @uses BookFlightSegmentType::setAvailableFlexiOperations()
     * @uses BookFlightSegmentType::setResBookDesigCode()
     * @uses BookFlightSegmentType::setResCabinClass()
     * @uses BookFlightSegmentType::setNumberInParty()
     * @uses BookFlightSegmentType::setStatus()
     * @uses BookFlightSegmentType::setE_TicketEligibility()
     * @uses BookFlightSegmentType::setMealCode()
     * @uses BookFlightSegmentType::setDepartureDay()
     * @param mixed $marriageGrp
     * @param \StructType\BookingClassAvails $bookingClassAvails
     * @param mixed[] $comment
     * @param \StructType\AvailableFlexiOperations $availableFlexiOperations
     * @param string $resBookDesigCode
     * @param string $resCabinClass
     * @param int $numberInParty
     * @param string $status
     * @param string $e_TicketEligibility
     * @param string $mealCode
     * @param string $departureDay
     */
    public function __construct($marriageGrp = null, \StructType\BookingClassAvails $bookingClassAvails = null, array $comment = array(), \StructType\AvailableFlexiOperations $availableFlexiOperations = null, $resBookDesigCode = null, $resCabinClass = null, $numberInParty = null, $status = null, $e_TicketEligibility = null, $mealCode = null, $departureDay = null)
    {
        $this
            ->setMarriageGrp($marriageGrp)
            ->setBookingClassAvails($bookingClassAvails)
            ->setComment($comment)
            ->setAvailableFlexiOperations($availableFlexiOperations)
            ->setResBookDesigCode($resBookDesigCode)
            ->setResCabinClass($resCabinClass)
            ->setNumberInParty($numberInParty)
            ->setStatus($status)
            ->setE_TicketEligibility($e_TicketEligibility)
            ->setMealCode($mealCode)
            ->setDepartureDay($departureDay);
    }
    /**
     * Get MarriageGrp value
     * @return mixed|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param mixed $marriageGrp
     * @return \StructType\BookFlightSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get BookingClassAvails value
     * @return \StructType\BookingClassAvails|null
     */
    public function getBookingClassAvails()
    {
        return $this->BookingClassAvails;
    }
    /**
     * Set BookingClassAvails value
     * @param \StructType\BookingClassAvails $bookingClassAvails
     * @return \StructType\BookFlightSegmentType
     */
    public function setBookingClassAvails(\StructType\BookingClassAvails $bookingClassAvails = null)
    {
        $this->BookingClassAvails = $bookingClassAvails;
        return $this;
    }
    /**
     * Get Comment value
     * @return mixed[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param mixed[] $comment
     * @return \StructType\BookFlightSegmentType
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $bookFlightSegmentTypeCommentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of anyType, "%s" given', is_object($bookFlightSegmentTypeCommentItem) ? get_class($bookFlightSegmentTypeCommentItem) : gettype($bookFlightSegmentTypeCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookFlightSegmentType
     */
    public function addToComment($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get AvailableFlexiOperations value
     * @return \StructType\AvailableFlexiOperations|null
     */
    public function getAvailableFlexiOperations()
    {
        return $this->AvailableFlexiOperations;
    }
    /**
     * Set AvailableFlexiOperations value
     * @param \StructType\AvailableFlexiOperations $availableFlexiOperations
     * @return \StructType\BookFlightSegmentType
     */
    public function setAvailableFlexiOperations(\StructType\AvailableFlexiOperations $availableFlexiOperations = null)
    {
        $this->AvailableFlexiOperations = $availableFlexiOperations;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\BookFlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ResCabinClass value
     * @return string|null
     */
    public function getResCabinClass()
    {
        return $this->ResCabinClass;
    }
    /**
     * Set ResCabinClass value
     * @param string $resCabinClass
     * @return \StructType\BookFlightSegmentType
     */
    public function setResCabinClass($resCabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($resCabinClass) && !is_string($resCabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resCabinClass)), __LINE__);
        }
        $this->ResCabinClass = $resCabinClass;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\BookFlightSegmentType
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !is_numeric($numberInParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BookFlightSegmentType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get E_TicketEligibility value
     * @return string|null
     */
    public function getE_TicketEligibility()
    {
        return $this->E_TicketEligibility;
    }
    /**
     * Set E_TicketEligibility value
     * @param string $e_TicketEligibility
     * @return \StructType\BookFlightSegmentType
     */
    public function setE_TicketEligibility($e_TicketEligibility = null)
    {
        // validation for constraint: string
        if (!is_null($e_TicketEligibility) && !is_string($e_TicketEligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e_TicketEligibility)), __LINE__);
        }
        $this->E_TicketEligibility = $e_TicketEligibility;
        return $this;
    }
    /**
     * Get MealCode value
     * @return string|null
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @param string $mealCode
     * @return \StructType\BookFlightSegmentType
     */
    public function setMealCode($mealCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealCode) && !is_string($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealCode)), __LINE__);
        }
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Get DepartureDay value
     * @return string|null
     */
    public function getDepartureDay()
    {
        return $this->DepartureDay;
    }
    /**
     * Set DepartureDay value
     * @param string $departureDay
     * @return \StructType\BookFlightSegmentType
     */
    public function setDepartureDay($departureDay = null)
    {
        // validation for constraint: string
        if (!is_null($departureDay) && !is_string($departureDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDay)), __LINE__);
        }
        $this->DepartureDay = $departureDay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
