<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold a passengers' baggage request | Attributes for baggage request
 * @subpackage Structs
 */
class BaggageRequestType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: The departure date of the flight for the baggage requested.
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: The number of the flight for which this baggage is requested.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for BaggageRequestType
     * @uses BaggageRequestType::setDepartureDate()
     * @uses BaggageRequestType::setFlightNumber()
     * @param string $departureDate
     * @param string $flightNumber
     */
    public function __construct($departureDate = null, $flightNumber = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\BaggageRequestType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\BaggageRequestType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
