<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageDetailsResponses StructType
 * Meta informations extracted from the WSDL
 * - documentation: Baggage details response element containing the results of the request
 * @subpackage Structs
 */
class BaggageDetailsResponses extends AbstractStructBase
{
    /**
     * The BaggageDetailsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\BaggageDetailsResponse[]
     */
    public $BaggageDetailsResponse;
    /**
     * The OnDBaggageDetailsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\OnDBaggageDetailsResponse[]
     */
    public $OnDBaggageDetailsResponse;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirTravelers
     */
    public $AirTravelers;
    /**
     * Constructor method for BaggageDetailsResponses
     * @uses BaggageDetailsResponses::setBaggageDetailsResponse()
     * @uses BaggageDetailsResponses::setOnDBaggageDetailsResponse()
     * @uses BaggageDetailsResponses::setAirTravelers()
     * @param \StructType\BaggageDetailsResponse[] $baggageDetailsResponse
     * @param \StructType\OnDBaggageDetailsResponse[] $onDBaggageDetailsResponse
     * @param \StructType\AirTravelers $airTravelers
     */
    public function __construct(array $baggageDetailsResponse = array(), array $onDBaggageDetailsResponse = array(), \StructType\AirTravelers $airTravelers = null)
    {
        $this
            ->setBaggageDetailsResponse($baggageDetailsResponse)
            ->setOnDBaggageDetailsResponse($onDBaggageDetailsResponse)
            ->setAirTravelers($airTravelers);
    }
    /**
     * Get BaggageDetailsResponse value
     * @return \StructType\BaggageDetailsResponse[]|null
     */
    public function getBaggageDetailsResponse()
    {
        return $this->BaggageDetailsResponse;
    }
    /**
     * Set BaggageDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageDetailsResponse[] $baggageDetailsResponse
     * @return \StructType\BaggageDetailsResponses
     */
    public function setBaggageDetailsResponse(array $baggageDetailsResponse = array())
    {
        foreach ($baggageDetailsResponse as $baggageDetailsResponsesBaggageDetailsResponseItem) {
            // validation for constraint: itemType
            if (!$baggageDetailsResponsesBaggageDetailsResponseItem instanceof \StructType\BaggageDetailsResponse) {
                throw new \InvalidArgumentException(sprintf('The BaggageDetailsResponse property can only contain items of \StructType\BaggageDetailsResponse, "%s" given', is_object($baggageDetailsResponsesBaggageDetailsResponseItem) ? get_class($baggageDetailsResponsesBaggageDetailsResponseItem) : gettype($baggageDetailsResponsesBaggageDetailsResponseItem)), __LINE__);
            }
        }
        $this->BaggageDetailsResponse = $baggageDetailsResponse;
        return $this;
    }
    /**
     * Add item to BaggageDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageDetailsResponse $item
     * @return \StructType\BaggageDetailsResponses
     */
    public function addToBaggageDetailsResponse(\StructType\BaggageDetailsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaggageDetailsResponse) {
            throw new \InvalidArgumentException(sprintf('The BaggageDetailsResponse property can only contain items of \StructType\BaggageDetailsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BaggageDetailsResponse[] = $item;
        return $this;
    }
    /**
     * Get OnDBaggageDetailsResponse value
     * @return \StructType\OnDBaggageDetailsResponse[]|null
     */
    public function getOnDBaggageDetailsResponse()
    {
        return $this->OnDBaggageDetailsResponse;
    }
    /**
     * Set OnDBaggageDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OnDBaggageDetailsResponse[] $onDBaggageDetailsResponse
     * @return \StructType\BaggageDetailsResponses
     */
    public function setOnDBaggageDetailsResponse(array $onDBaggageDetailsResponse = array())
    {
        foreach ($onDBaggageDetailsResponse as $baggageDetailsResponsesOnDBaggageDetailsResponseItem) {
            // validation for constraint: itemType
            if (!$baggageDetailsResponsesOnDBaggageDetailsResponseItem instanceof \StructType\OnDBaggageDetailsResponse) {
                throw new \InvalidArgumentException(sprintf('The OnDBaggageDetailsResponse property can only contain items of \StructType\OnDBaggageDetailsResponse, "%s" given', is_object($baggageDetailsResponsesOnDBaggageDetailsResponseItem) ? get_class($baggageDetailsResponsesOnDBaggageDetailsResponseItem) : gettype($baggageDetailsResponsesOnDBaggageDetailsResponseItem)), __LINE__);
            }
        }
        $this->OnDBaggageDetailsResponse = $onDBaggageDetailsResponse;
        return $this;
    }
    /**
     * Add item to OnDBaggageDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OnDBaggageDetailsResponse $item
     * @return \StructType\BaggageDetailsResponses
     */
    public function addToOnDBaggageDetailsResponse(\StructType\OnDBaggageDetailsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnDBaggageDetailsResponse) {
            throw new \InvalidArgumentException(sprintf('The OnDBaggageDetailsResponse property can only contain items of \StructType\OnDBaggageDetailsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OnDBaggageDetailsResponse[] = $item;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \StructType\AirTravelers|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \StructType\AirTravelers $airTravelers
     * @return \StructType\BaggageDetailsResponses
     */
    public function setAirTravelers(\StructType\AirTravelers $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageDetailsResponses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
