<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold the baggage details that is to be requested.
 * @subpackage Structs
 */
class BaggageDetails extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The ResBookDesignations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResBookDesignations
     */
    public $ResBookDesignations;
    /**
     * Constructor method for BaggageDetails
     * @uses BaggageDetails::setCabinClass()
     * @uses BaggageDetails::setResBookDesignations()
     * @param \StructType\CabinClass[] $cabinClass
     * @param \StructType\ResBookDesignations $resBookDesignations
     */
    public function __construct(array $cabinClass = array(), \StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setResBookDesignations($resBookDesignations);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\BaggageDetails
     */
    public function setCabinClass(array $cabinClass = array())
    {
        foreach ($cabinClass as $baggageDetailsCabinClassItem) {
            // validation for constraint: itemType
            if (!$baggageDetailsCabinClassItem instanceof \StructType\CabinClass) {
                throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($baggageDetailsCabinClassItem) ? get_class($baggageDetailsCabinClassItem) : gettype($baggageDetailsCabinClassItem)), __LINE__);
            }
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\BaggageDetails
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesignations value
     * @return \StructType\ResBookDesignations|null
     */
    public function getResBookDesignations()
    {
        return $this->ResBookDesignations;
    }
    /**
     * Set ResBookDesignations value
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @return \StructType\BaggageDetails
     */
    public function setResBookDesignations(\StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this->ResBookDesignations = $resBookDesignations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
