<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirportService StructType
 * @subpackage Structs
 */
class AirportService extends AbstractStructBase
{
    /**
     * The ssrCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrCode;
    /**
     * The ssrName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrName;
    /**
     * The ssrDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrDescription;
    /**
     * The applicabilityType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $applicabilityType;
    /**
     * The adultAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $adultAmount;
    /**
     * The childAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $childAmount;
    /**
     * The infantAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $infantAmount;
    /**
     * The reservationAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $reservationAmount;
    /**
     * Constructor method for AirportService
     * @uses AirportService::setSsrCode()
     * @uses AirportService::setSsrName()
     * @uses AirportService::setSsrDescription()
     * @uses AirportService::setApplicabilityType()
     * @uses AirportService::setAdultAmount()
     * @uses AirportService::setChildAmount()
     * @uses AirportService::setInfantAmount()
     * @uses AirportService::setReservationAmount()
     * @param string $ssrCode
     * @param string $ssrName
     * @param string $ssrDescription
     * @param string $applicabilityType
     * @param float $adultAmount
     * @param float $childAmount
     * @param float $infantAmount
     * @param float $reservationAmount
     */
    public function __construct($ssrCode = null, $ssrName = null, $ssrDescription = null, $applicabilityType = null, $adultAmount = null, $childAmount = null, $infantAmount = null, $reservationAmount = null)
    {
        $this
            ->setSsrCode($ssrCode)
            ->setSsrName($ssrName)
            ->setSsrDescription($ssrDescription)
            ->setApplicabilityType($applicabilityType)
            ->setAdultAmount($adultAmount)
            ->setChildAmount($childAmount)
            ->setInfantAmount($infantAmount)
            ->setReservationAmount($reservationAmount);
    }
    /**
     * Get ssrCode value
     * @return string
     */
    public function getSsrCode()
    {
        return $this->ssrCode;
    }
    /**
     * Set ssrCode value
     * @param string $ssrCode
     * @return \StructType\AirportService
     */
    public function setSsrCode($ssrCode = null)
    {
        // validation for constraint: string
        if (!is_null($ssrCode) && !is_string($ssrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrCode)), __LINE__);
        }
        $this->ssrCode = $ssrCode;
        return $this;
    }
    /**
     * Get ssrName value
     * @return string
     */
    public function getSsrName()
    {
        return $this->ssrName;
    }
    /**
     * Set ssrName value
     * @param string $ssrName
     * @return \StructType\AirportService
     */
    public function setSsrName($ssrName = null)
    {
        // validation for constraint: string
        if (!is_null($ssrName) && !is_string($ssrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrName)), __LINE__);
        }
        $this->ssrName = $ssrName;
        return $this;
    }
    /**
     * Get ssrDescription value
     * @return string
     */
    public function getSsrDescription()
    {
        return $this->ssrDescription;
    }
    /**
     * Set ssrDescription value
     * @param string $ssrDescription
     * @return \StructType\AirportService
     */
    public function setSsrDescription($ssrDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ssrDescription) && !is_string($ssrDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrDescription)), __LINE__);
        }
        $this->ssrDescription = $ssrDescription;
        return $this;
    }
    /**
     * Get applicabilityType value
     * @return string
     */
    public function getApplicabilityType()
    {
        return $this->applicabilityType;
    }
    /**
     * Set applicabilityType value
     * @param string $applicabilityType
     * @return \StructType\AirportService
     */
    public function setApplicabilityType($applicabilityType = null)
    {
        // validation for constraint: string
        if (!is_null($applicabilityType) && !is_string($applicabilityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicabilityType)), __LINE__);
        }
        $this->applicabilityType = $applicabilityType;
        return $this;
    }
    /**
     * Get adultAmount value
     * @return float
     */
    public function getAdultAmount()
    {
        return $this->adultAmount;
    }
    /**
     * Set adultAmount value
     * @param float $adultAmount
     * @return \StructType\AirportService
     */
    public function setAdultAmount($adultAmount = null)
    {
        $this->adultAmount = $adultAmount;
        return $this;
    }
    /**
     * Get childAmount value
     * @return float
     */
    public function getChildAmount()
    {
        return $this->childAmount;
    }
    /**
     * Set childAmount value
     * @param float $childAmount
     * @return \StructType\AirportService
     */
    public function setChildAmount($childAmount = null)
    {
        $this->childAmount = $childAmount;
        return $this;
    }
    /**
     * Get infantAmount value
     * @return float
     */
    public function getInfantAmount()
    {
        return $this->infantAmount;
    }
    /**
     * Set infantAmount value
     * @param float $infantAmount
     * @return \StructType\AirportService
     */
    public function setInfantAmount($infantAmount = null)
    {
        $this->infantAmount = $infantAmount;
        return $this;
    }
    /**
     * Get reservationAmount value
     * @return float
     */
    public function getReservationAmount()
    {
        return $this->reservationAmount;
    }
    /**
     * Set reservationAmount value
     * @param float $reservationAmount
     * @return \StructType\AirportService
     */
    public function setReservationAmount($reservationAmount = null)
    {
        $this->reservationAmount = $reservationAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirportService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
