<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains all booking response information pertaining to a completed reservation.
 * @subpackage Structs
 */
class AirReservationType extends AbstractStructBase
{
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - documentation: A collection of all flight segments requested for booking.
     * - minOccurs: 0
     * @var mixed
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta informations extracted from the WSDL
     * - documentation: Pricing information for the air itinerary to be booked e.g. this data could come from the OTA_AirPriceRS data.
     * - minOccurs: 0
     * @var mixed
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - documentation: All traveler information relevant to a booking request.
     * - minOccurs: 0
     * @var mixed
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fulfillment
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - documentation: Information used to specify the ticketing arrangement.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Ticketing;
    /**
     * The Queues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Queues
     */
    public $Queues;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: Optional field available for use by trading partners as determined by their needs.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BookingReferenceID;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TravelersFulfillments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TravelersFulfillments
     * @var \StructType\TravelersFulfillments
     */
    public $TravelersFulfillments;
    /**
     * The LastModified
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LastModified;
    /**
     * Constructor method for AirReservationType
     * @uses AirReservationType::setAirItinerary()
     * @uses AirReservationType::setPriceInfo()
     * @uses AirReservationType::setTravelerInfo()
     * @uses AirReservationType::setFulfillment()
     * @uses AirReservationType::setTicketing()
     * @uses AirReservationType::setQueues()
     * @uses AirReservationType::setBookingReferenceID()
     * @uses AirReservationType::setTPA_Extensions()
     * @uses AirReservationType::setTravelersFulfillments()
     * @uses AirReservationType::setLastModified()
     * @param mixed $airItinerary
     * @param mixed $priceInfo
     * @param mixed $travelerInfo
     * @param \StructType\Fulfillment $fulfillment
     * @param mixed[] $ticketing
     * @param \StructType\Queues $queues
     * @param mixed[] $bookingReferenceID
     * @param mixed $tPA_Extensions
     * @param \StructType\TravelersFulfillments $travelersFulfillments
     * @param string $lastModified
     */
    public function __construct($airItinerary = null, $priceInfo = null, $travelerInfo = null, \StructType\Fulfillment $fulfillment = null, array $ticketing = array(), \StructType\Queues $queues = null, array $bookingReferenceID = array(), $tPA_Extensions = null, \StructType\TravelersFulfillments $travelersFulfillments = null, $lastModified = null)
    {
        $this
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setQueues($queues)
            ->setBookingReferenceID($bookingReferenceID)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTravelersFulfillments($travelersFulfillments)
            ->setLastModified($lastModified);
    }
    /**
     * Get AirItinerary value
     * @return mixed|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param mixed $airItinerary
     * @return \StructType\AirReservationType
     */
    public function setAirItinerary($airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return mixed|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param mixed $priceInfo
     * @return \StructType\AirReservationType
     */
    public function setPriceInfo($priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return mixed|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param mixed $travelerInfo
     * @return \StructType\AirReservationType
     */
    public function setTravelerInfo($travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \StructType\Fulfillment|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \StructType\Fulfillment $fulfillment
     * @return \StructType\AirReservationType
     */
    public function setFulfillment(\StructType\Fulfillment $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return mixed[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketing
     * @return \StructType\AirReservationType
     */
    public function setTicketing(array $ticketing = array())
    {
        foreach ($ticketing as $airReservationTypeTicketingItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of anyType, "%s" given', is_object($airReservationTypeTicketingItem) ? get_class($airReservationTypeTicketingItem) : gettype($airReservationTypeTicketingItem)), __LINE__);
            }
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirReservationType
     */
    public function addToTicketing($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Queues value
     * @return \StructType\Queues|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @param \StructType\Queues $queues
     * @return \StructType\AirReservationType
     */
    public function setQueues(\StructType\Queues $queues = null)
    {
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return mixed[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed[] $bookingReferenceID
     * @return \StructType\AirReservationType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $airReservationTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of anyType, "%s" given', is_object($airReservationTypeBookingReferenceIDItem) ? get_class($airReservationTypeBookingReferenceIDItem) : gettype($airReservationTypeBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirReservationType
     */
    public function addToBookingReferenceID($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirReservationType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TravelersFulfillments value
     * @return \StructType\TravelersFulfillments|null
     */
    public function getTravelersFulfillments()
    {
        return $this->TravelersFulfillments;
    }
    /**
     * Set TravelersFulfillments value
     * @param \StructType\TravelersFulfillments $travelersFulfillments
     * @return \StructType\AirReservationType
     */
    public function setTravelersFulfillments(\StructType\TravelersFulfillments $travelersFulfillments = null)
    {
        $this->TravelersFulfillments = $travelersFulfillments;
        return $this;
    }
    /**
     * Get LastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->LastModified;
    }
    /**
     * Set LastModified value
     * @param string $lastModified
     * @return \StructType\AirReservationType
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModified)), __LINE__);
        }
        $this->LastModified = $lastModified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
