<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Pricing Information for an Air Itinerary
 * @subpackage Structs
 */
class AirItineraryPricingInfoType extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - documentation: Total price of the itinerary
     * - minOccurs: 0
     * @var mixed
     */
    public $ItinTotalFare;
    /**
     * The PTC_FareBreakdowns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PTC_FareBreakdowns
     */
    public $PTC_FareBreakdowns;
    /**
     * The FareInfos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareInfos
     */
    public $FareInfos;
    /**
     * The AvailableFlexiFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AvailableFlexiFares
     */
    public $AvailableFlexiFares;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate whether the pricing is public or private
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * Constructor method for AirItineraryPricingInfoType
     * @uses AirItineraryPricingInfoType::setItinTotalFare()
     * @uses AirItineraryPricingInfoType::setPTC_FareBreakdowns()
     * @uses AirItineraryPricingInfoType::setFareInfos()
     * @uses AirItineraryPricingInfoType::setAvailableFlexiFares()
     * @uses AirItineraryPricingInfoType::setPricingSource()
     * @param mixed $itinTotalFare
     * @param \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @param \StructType\FareInfos $fareInfos
     * @param \StructType\AvailableFlexiFares $availableFlexiFares
     * @param string $pricingSource
     */
    public function __construct($itinTotalFare = null, \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null, \StructType\FareInfos $fareInfos = null, \StructType\AvailableFlexiFares $availableFlexiFares = null, $pricingSource = null)
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setPTC_FareBreakdowns($pTC_FareBreakdowns)
            ->setFareInfos($fareInfos)
            ->setAvailableFlexiFares($availableFlexiFares)
            ->setPricingSource($pricingSource);
    }
    /**
     * Get ItinTotalFare value
     * @return mixed|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @param mixed $itinTotalFare
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setItinTotalFare($itinTotalFare = null)
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Get PTC_FareBreakdowns value
     * @return \StructType\PTC_FareBreakdowns|null
     */
    public function getPTC_FareBreakdowns()
    {
        return $this->PTC_FareBreakdowns;
    }
    /**
     * Set PTC_FareBreakdowns value
     * @param \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setPTC_FareBreakdowns(\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null)
    {
        $this->PTC_FareBreakdowns = $pTC_FareBreakdowns;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \StructType\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \StructType\FareInfos $fareInfos
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setFareInfos(\StructType\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get AvailableFlexiFares value
     * @return \StructType\AvailableFlexiFares|null
     */
    public function getAvailableFlexiFares()
    {
        return $this->AvailableFlexiFares;
    }
    /**
     * Set AvailableFlexiFares value
     * @param \StructType\AvailableFlexiFares $availableFlexiFares
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setAvailableFlexiFares(\StructType\AvailableFlexiFares $availableFlexiFares = null)
    {
        $this->AvailableFlexiFares = $availableFlexiFares;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: string
        if (!is_null($pricingSource) && !is_string($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pricingSource)), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirItineraryPricingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
