<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookModifyRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the new value of data which is to be modified.
 * @subpackage Structs
 */
class AirBookModifyRQ extends AirReservationType
{
    /**
     * The ModificationType
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the type of booking modification being requested. Refer to OTA Code List Modification Type (MOD). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: optional
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $ModificationType;
    /**
     * Constructor method for AirBookModifyRQ
     * @uses AirBookModifyRQ::setModificationType()
     * @param string $modificationType
     */
    public function __construct($modificationType = null)
    {
        $this
            ->setModificationType($modificationType);
    }
    /**
     * Get ModificationType value
     * @return string|null
     */
    public function getModificationType()
    {
        return $this->ModificationType;
    }
    /**
     * Set ModificationType value
     * @param string $modificationType
     * @return \StructType\AirBookModifyRQ
     */
    public function setModificationType($modificationType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($modificationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $modificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}", "%s" given', var_export($modificationType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modificationType) && !is_string($modificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationType)), __LINE__);
        }
        $this->ModificationType = $modificationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirBookModifyRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
