<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AA_OTA_ETicketStatusUpdateRS StructType
 * @subpackage Structs
 */
class AA_OTA_ETicketStatusUpdateRS extends AbstractStructBase
{
    /**
     * The statusErrorsAndWarnings
     * @var \StructType\AAStatusErrorsAndWarnings
     */
    public $statusErrorsAndWarnings;
    /**
     * The usabilityStatus
     * @var string
     */
    public $usabilityStatus;
    /**
     * Constructor method for AA_OTA_ETicketStatusUpdateRS
     * @uses AA_OTA_ETicketStatusUpdateRS::setStatusErrorsAndWarnings()
     * @uses AA_OTA_ETicketStatusUpdateRS::setUsabilityStatus()
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @param string $usabilityStatus
     */
    public function __construct(\StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null, $usabilityStatus = null)
    {
        $this
            ->setStatusErrorsAndWarnings($statusErrorsAndWarnings)
            ->setUsabilityStatus($usabilityStatus);
    }
    /**
     * Get statusErrorsAndWarnings value
     * @return \StructType\AAStatusErrorsAndWarnings|null
     */
    public function getStatusErrorsAndWarnings()
    {
        return $this->statusErrorsAndWarnings;
    }
    /**
     * Set statusErrorsAndWarnings value
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @return \StructType\AA_OTA_ETicketStatusUpdateRS
     */
    public function setStatusErrorsAndWarnings(\StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null)
    {
        $this->statusErrorsAndWarnings = $statusErrorsAndWarnings;
        return $this;
    }
    /**
     * Get usabilityStatus value
     * @return string|null
     */
    public function getUsabilityStatus()
    {
        return $this->usabilityStatus;
    }
    /**
     * Set usabilityStatus value
     * @uses \EnumType\EticketUserbilityStatusType::valueIsValid()
     * @uses \EnumType\EticketUserbilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usabilityStatus
     * @return \StructType\AA_OTA_ETicketStatusUpdateRS
     */
    public function setUsabilityStatus($usabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EticketUserbilityStatusType::valueIsValid($usabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usabilityStatus, implode(', ', \EnumType\EticketUserbilityStatusType::getValidValues())), __LINE__);
        }
        $this->usabilityStatus = $usabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AA_OTA_ETicketStatusUpdateRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
