<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AA_OTA_AirMealDetailsRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: The meal details Request message requests meal details for one or more flight segments for specific dates. The request can include the PNR number , frequent flier numbers etc. The meal details response contains the actual meal
 * details based on the input conditions in the request message. Every flight segment will have a separate meal detail
 * @subpackage Structs
 */
class AA_OTA_AirMealDetailsRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The MealDetailsRequests
     * @var \StructType\MealDetailsRequests
     */
    public $MealDetailsRequests;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirTravelers
     */
    public $AirTravelers;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for AA_OTA_AirMealDetailsRQ
     * @uses AA_OTA_AirMealDetailsRQ::setPOS()
     * @uses AA_OTA_AirMealDetailsRQ::setMealDetailsRequests()
     * @uses AA_OTA_AirMealDetailsRQ::setAirTravelers()
     * @uses AA_OTA_AirMealDetailsRQ::setBookingReferenceID()
     * @uses AA_OTA_AirMealDetailsRQ::setEchoToken()
     * @uses AA_OTA_AirMealDetailsRQ::setTimeStamp()
     * @uses AA_OTA_AirMealDetailsRQ::setTarget()
     * @uses AA_OTA_AirMealDetailsRQ::setVersion()
     * @uses AA_OTA_AirMealDetailsRQ::setTransactionIdentifier()
     * @uses AA_OTA_AirMealDetailsRQ::setSequenceNmbr()
     * @uses AA_OTA_AirMealDetailsRQ::setTransactionStatusCode()
     * @uses AA_OTA_AirMealDetailsRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\MealDetailsRequests $mealDetailsRequests
     * @param \StructType\AirTravelers $airTravelers
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\MealDetailsRequests $mealDetailsRequests = null, \StructType\AirTravelers $airTravelers = null, array $bookingReferenceID = array(), $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setMealDetailsRequests($mealDetailsRequests)
            ->setAirTravelers($airTravelers)
            ->setBookingReferenceID($bookingReferenceID)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get MealDetailsRequests value
     * @return \StructType\MealDetailsRequests|null
     */
    public function getMealDetailsRequests()
    {
        return $this->MealDetailsRequests;
    }
    /**
     * Set MealDetailsRequests value
     * @param \StructType\MealDetailsRequests $mealDetailsRequests
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setMealDetailsRequests(\StructType\MealDetailsRequests $mealDetailsRequests = null)
    {
        $this->MealDetailsRequests = $mealDetailsRequests;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \StructType\AirTravelers|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \StructType\AirTravelers $airTravelers
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setAirTravelers(\StructType\AirTravelers $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $aA_OTA_AirMealDetailsRQBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$aA_OTA_AirMealDetailsRQBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($aA_OTA_AirMealDetailsRQBookingReferenceIDItem) ? get_class($aA_OTA_AirMealDetailsRQBookingReferenceIDItem) : gettype($aA_OTA_AirMealDetailsRQBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AA_OTA_AirMealDetailsRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
