<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAUserNoteType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Free Text Note
 * @subpackage Structs
 */
class AAUserNoteType extends AbstractStructBase
{
    /**
     * The NoteText
     * @var string
     */
    public $NoteText;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $Date;
    /**
     * The ActionName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionName;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for AAUserNoteType
     * @uses AAUserNoteType::setNoteText()
     * @uses AAUserNoteType::setDate()
     * @uses AAUserNoteType::setActionName()
     * @uses AAUserNoteType::setUserName()
     * @param string $noteText
     * @param string $date
     * @param string $actionName
     * @param string $userName
     */
    public function __construct($noteText = null, $date = null, $actionName = null, $userName = null)
    {
        $this
            ->setNoteText($noteText)
            ->setDate($date)
            ->setActionName($actionName)
            ->setUserName($userName);
    }
    /**
     * Get NoteText value
     * @return string|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param string $noteText
     * @return \StructType\AAUserNoteType
     */
    public function setNoteText($noteText = null)
    {
        // validation for constraint: string
        if (!is_null($noteText) && !is_string($noteText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteText)), __LINE__);
        }
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AAUserNoteType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get ActionName value
     * @return string|null
     */
    public function getActionName()
    {
        return $this->ActionName;
    }
    /**
     * Set ActionName value
     * @param string $actionName
     * @return \StructType\AAUserNoteType
     */
    public function setActionName($actionName = null)
    {
        // validation for constraint: string
        if (!is_null($actionName) && !is_string($actionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionName)), __LINE__);
        }
        $this->ActionName = $actionName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AAUserNoteType
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAUserNoteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
