<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AATravelerAccSummaryType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Traveler(PAX) total payment, balance and credit.
 * @subpackage Structs
 */
class AATravelerAccSummaryType extends AbstractStructBase
{
    /**
     * The TravelerRefNumberRPH
     * @var string
     */
    public $TravelerRefNumberRPH;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - documentation: Total Price For Traveler(Pax).
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPrice;
    /**
     * The TotalPaidAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total Payment Recorded For Traveler(Pax).
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalPaidAmount;
    /**
     * The TotalBalanceDue
     * Meta informations extracted from the WSDL
     * - documentation: Total Amount Due For Traveler(Pax).
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalBalanceDue;
    /**
     * The TotalCreditAvailable
     * Meta informations extracted from the WSDL
     * - documentation: Total Credit Available For Traveler(Pax).
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalCreditAvailable;
    /**
     * Constructor method for AATravelerAccSummaryType
     * @uses AATravelerAccSummaryType::setTravelerRefNumberRPH()
     * @uses AATravelerAccSummaryType::setTotalPrice()
     * @uses AATravelerAccSummaryType::setTotalPaidAmount()
     * @uses AATravelerAccSummaryType::setTotalBalanceDue()
     * @uses AATravelerAccSummaryType::setTotalCreditAvailable()
     * @param string $travelerRefNumberRPH
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @param \StructType\AACurrencyAmountType $totalPaidAmount
     * @param \StructType\AACurrencyAmountType $totalBalanceDue
     * @param \StructType\AACurrencyAmountType $totalCreditAvailable
     */
    public function __construct($travelerRefNumberRPH = null, \StructType\AACurrencyAmountType $totalPrice = null, \StructType\AACurrencyAmountType $totalPaidAmount = null, \StructType\AACurrencyAmountType $totalBalanceDue = null, \StructType\AACurrencyAmountType $totalCreditAvailable = null)
    {
        $this
            ->setTravelerRefNumberRPH($travelerRefNumberRPH)
            ->setTotalPrice($totalPrice)
            ->setTotalPaidAmount($totalPaidAmount)
            ->setTotalBalanceDue($totalBalanceDue)
            ->setTotalCreditAvailable($totalCreditAvailable);
    }
    /**
     * Get TravelerRefNumberRPH value
     * @return string|null
     */
    public function getTravelerRefNumberRPH()
    {
        return $this->TravelerRefNumberRPH;
    }
    /**
     * Set TravelerRefNumberRPH value
     * @param string $travelerRefNumberRPH
     * @return \StructType\AATravelerAccSummaryType
     */
    public function setTravelerRefNumberRPH($travelerRefNumberRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumberRPH) && !is_string($travelerRefNumberRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumberRPH)), __LINE__);
        }
        $this->TravelerRefNumberRPH = $travelerRefNumberRPH;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\AACurrencyAmountType $totalPrice
     * @return \StructType\AATravelerAccSummaryType
     */
    public function setTotalPrice(\StructType\AACurrencyAmountType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalPaidAmount value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalPaidAmount()
    {
        return $this->TotalPaidAmount;
    }
    /**
     * Set TotalPaidAmount value
     * @param \StructType\AACurrencyAmountType $totalPaidAmount
     * @return \StructType\AATravelerAccSummaryType
     */
    public function setTotalPaidAmount(\StructType\AACurrencyAmountType $totalPaidAmount = null)
    {
        $this->TotalPaidAmount = $totalPaidAmount;
        return $this;
    }
    /**
     * Get TotalBalanceDue value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalBalanceDue()
    {
        return $this->TotalBalanceDue;
    }
    /**
     * Set TotalBalanceDue value
     * @param \StructType\AACurrencyAmountType $totalBalanceDue
     * @return \StructType\AATravelerAccSummaryType
     */
    public function setTotalBalanceDue(\StructType\AACurrencyAmountType $totalBalanceDue = null)
    {
        $this->TotalBalanceDue = $totalBalanceDue;
        return $this;
    }
    /**
     * Get TotalCreditAvailable value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalCreditAvailable()
    {
        return $this->TotalCreditAvailable;
    }
    /**
     * Set TotalCreditAvailable value
     * @param \StructType\AACurrencyAmountType $totalCreditAvailable
     * @return \StructType\AATravelerAccSummaryType
     */
    public function setTotalCreditAvailable(\StructType\AACurrencyAmountType $totalCreditAvailable = null)
    {
        $this->TotalCreditAvailable = $totalCreditAvailable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AATravelerAccSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
