<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPropertyType StructType
 * Meta informations extracted from the WSDL
 * - documentation: A string property (defined by key, value pair)
 * @subpackage Structs
 */
class AAPropertyType extends AbstractStructBase
{
    /**
     * The keyValuePair
     * Meta informations extracted from the WSDL
     * - documentation: Use as "key=value"
     * @var string
     */
    public $keyValuePair;
    /**
     * Constructor method for AAPropertyType
     * @uses AAPropertyType::setKeyValuePair()
     * @param string $keyValuePair
     */
    public function __construct($keyValuePair = null)
    {
        $this
            ->setKeyValuePair($keyValuePair);
    }
    /**
     * Get keyValuePair value
     * @return string|null
     */
    public function getKeyValuePair()
    {
        return $this->keyValuePair;
    }
    /**
     * Set keyValuePair value
     * @param string $keyValuePair
     * @return \StructType\AAPropertyType
     */
    public function setKeyValuePair($keyValuePair = null)
    {
        // validation for constraint: string
        if (!is_null($keyValuePair) && !is_string($keyValuePair)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyValuePair)), __LINE__);
        }
        $this->keyValuePair = $keyValuePair;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
