<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPnrPaxCreditType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Pnr Pax credit information.
 * @subpackage Structs
 */
class AAPnrPaxCreditType extends AbstractStructBase
{
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: Mandantory booking reference ID
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - documentation: A collection of all flight segments the booking consists of.
     * - minOccurs: 0
     * @var \StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The PaxCredit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \StructType\AAPaxCreditType[]
     */
    public $PaxCredit;
    /**
     * Constructor method for AAPnrPaxCreditType
     * @uses AAPnrPaxCreditType::setBookingReferenceID()
     * @uses AAPnrPaxCreditType::setAirItinerary()
     * @uses AAPnrPaxCreditType::setPaxCredit()
     * @param string $bookingReferenceID
     * @param \StructType\AirItineraryType $airItinerary
     * @param \StructType\AAPaxCreditType[] $paxCredit
     */
    public function __construct($bookingReferenceID = null, \StructType\AirItineraryType $airItinerary = null, array $paxCredit = array())
    {
        $this
            ->setBookingReferenceID($bookingReferenceID)
            ->setAirItinerary($airItinerary)
            ->setPaxCredit($paxCredit);
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AAPnrPaxCreditType
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \StructType\AirItineraryType $airItinerary
     * @return \StructType\AAPnrPaxCreditType
     */
    public function setAirItinerary(\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PaxCredit value
     * @return \StructType\AAPaxCreditType[]|null
     */
    public function getPaxCredit()
    {
        return $this->PaxCredit;
    }
    /**
     * Set PaxCredit value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxCreditType[] $paxCredit
     * @return \StructType\AAPnrPaxCreditType
     */
    public function setPaxCredit(array $paxCredit = array())
    {
        foreach ($paxCredit as $aAPnrPaxCreditTypePaxCreditItem) {
            // validation for constraint: itemType
            if (!$aAPnrPaxCreditTypePaxCreditItem instanceof \StructType\AAPaxCreditType) {
                throw new \InvalidArgumentException(sprintf('The PaxCredit property can only contain items of \StructType\AAPaxCreditType, "%s" given', is_object($aAPnrPaxCreditTypePaxCreditItem) ? get_class($aAPnrPaxCreditTypePaxCreditItem) : gettype($aAPnrPaxCreditTypePaxCreditItem)), __LINE__);
            }
        }
        $this->PaxCredit = $paxCredit;
        return $this;
    }
    /**
     * Add item to PaxCredit value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPaxCreditType $item
     * @return \StructType\AAPnrPaxCreditType
     */
    public function addToPaxCredit(\StructType\AAPaxCreditType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPaxCreditType) {
            throw new \InvalidArgumentException(sprintf('The PaxCredit property can only contain items of \StructType\AAPaxCreditType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaxCredit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPnrPaxCreditType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
