<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPTCCountType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Passenger Count of specified PassengerTypeCode(PTC)
 * @subpackage Structs
 */
class AAPTCCountType extends AbstractStructBase
{
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The PassengerTypeQuantity
     * @var int
     */
    public $PassengerTypeQuantity;
    /**
     * Constructor method for AAPTCCountType
     * @uses AAPTCCountType::setPassengerTypeCode()
     * @uses AAPTCCountType::setPassengerTypeQuantity()
     * @param string $passengerTypeCode
     * @param int $passengerTypeQuantity
     */
    public function __construct($passengerTypeCode = null, $passengerTypeQuantity = null)
    {
        $this
            ->setPassengerTypeCode($passengerTypeCode)
            ->setPassengerTypeQuantity($passengerTypeQuantity);
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\AAPTCCountType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return int|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param int $passengerTypeQuantity
     * @return \StructType\AAPTCCountType
     */
    public function setPassengerTypeQuantity($passengerTypeQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeQuantity) && !is_numeric($passengerTypeQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerTypeQuantity)), __LINE__);
        }
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPTCCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
