<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRPaxTransactionType StructType
 * @subpackage Structs
 */
class AAPNRPaxTransactionType extends AbstractStructBase
{
    /**
     * The amountInBaseCurrency
     * @var \StructType\AmountInBaseCurrency
     */
    public $amountInBaseCurrency;
    /**
     * The amountInPayCurrency
     * @var \StructType\AmountInPayCurrency
     */
    public $amountInPayCurrency;
    /**
     * The txnRPH
     * @var string
     */
    public $txnRPH;
    /**
     * The date
     * @var string
     */
    public $date;
    /**
     * The collectedUserId
     * @var string
     */
    public $collectedUserId;
    /**
     * The payCurrencyCode
     * @var string
     */
    public $payCurrencyCode;
    /**
     * The exchangeRate
     * @var float
     */
    public $exchangeRate;
    /**
     * The paymentTypeCode
     * @var string
     */
    public $paymentTypeCode;
    /**
     * The agencyCode
     * @var string
     */
    public $agencyCode;
    /**
     * Constructor method for AAPNRPaxTransactionType
     * @uses AAPNRPaxTransactionType::setAmountInBaseCurrency()
     * @uses AAPNRPaxTransactionType::setAmountInPayCurrency()
     * @uses AAPNRPaxTransactionType::setTxnRPH()
     * @uses AAPNRPaxTransactionType::setDate()
     * @uses AAPNRPaxTransactionType::setCollectedUserId()
     * @uses AAPNRPaxTransactionType::setPayCurrencyCode()
     * @uses AAPNRPaxTransactionType::setExchangeRate()
     * @uses AAPNRPaxTransactionType::setPaymentTypeCode()
     * @uses AAPNRPaxTransactionType::setAgencyCode()
     * @param \StructType\AmountInBaseCurrency $amountInBaseCurrency
     * @param \StructType\AmountInPayCurrency $amountInPayCurrency
     * @param string $txnRPH
     * @param string $date
     * @param string $collectedUserId
     * @param string $payCurrencyCode
     * @param float $exchangeRate
     * @param string $paymentTypeCode
     * @param string $agencyCode
     */
    public function __construct(\StructType\AmountInBaseCurrency $amountInBaseCurrency = null, \StructType\AmountInPayCurrency $amountInPayCurrency = null, $txnRPH = null, $date = null, $collectedUserId = null, $payCurrencyCode = null, $exchangeRate = null, $paymentTypeCode = null, $agencyCode = null)
    {
        $this
            ->setAmountInBaseCurrency($amountInBaseCurrency)
            ->setAmountInPayCurrency($amountInPayCurrency)
            ->setTxnRPH($txnRPH)
            ->setDate($date)
            ->setCollectedUserId($collectedUserId)
            ->setPayCurrencyCode($payCurrencyCode)
            ->setExchangeRate($exchangeRate)
            ->setPaymentTypeCode($paymentTypeCode)
            ->setAgencyCode($agencyCode);
    }
    /**
     * Get amountInBaseCurrency value
     * @return \StructType\AmountInBaseCurrency|null
     */
    public function getAmountInBaseCurrency()
    {
        return $this->amountInBaseCurrency;
    }
    /**
     * Set amountInBaseCurrency value
     * @param \StructType\AmountInBaseCurrency $amountInBaseCurrency
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setAmountInBaseCurrency(\StructType\AmountInBaseCurrency $amountInBaseCurrency = null)
    {
        $this->amountInBaseCurrency = $amountInBaseCurrency;
        return $this;
    }
    /**
     * Get amountInPayCurrency value
     * @return \StructType\AmountInPayCurrency|null
     */
    public function getAmountInPayCurrency()
    {
        return $this->amountInPayCurrency;
    }
    /**
     * Set amountInPayCurrency value
     * @param \StructType\AmountInPayCurrency $amountInPayCurrency
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setAmountInPayCurrency(\StructType\AmountInPayCurrency $amountInPayCurrency = null)
    {
        $this->amountInPayCurrency = $amountInPayCurrency;
        return $this;
    }
    /**
     * Get txnRPH value
     * @return string|null
     */
    public function getTxnRPH()
    {
        return $this->txnRPH;
    }
    /**
     * Set txnRPH value
     * @param string $txnRPH
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setTxnRPH($txnRPH = null)
    {
        // validation for constraint: string
        if (!is_null($txnRPH) && !is_string($txnRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($txnRPH)), __LINE__);
        }
        $this->txnRPH = $txnRPH;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get collectedUserId value
     * @return string|null
     */
    public function getCollectedUserId()
    {
        return $this->collectedUserId;
    }
    /**
     * Set collectedUserId value
     * @param string $collectedUserId
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setCollectedUserId($collectedUserId = null)
    {
        // validation for constraint: string
        if (!is_null($collectedUserId) && !is_string($collectedUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectedUserId)), __LINE__);
        }
        $this->collectedUserId = $collectedUserId;
        return $this;
    }
    /**
     * Get payCurrencyCode value
     * @return string|null
     */
    public function getPayCurrencyCode()
    {
        return $this->payCurrencyCode;
    }
    /**
     * Set payCurrencyCode value
     * @param string $payCurrencyCode
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setPayCurrencyCode($payCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($payCurrencyCode) && !is_string($payCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payCurrencyCode)), __LINE__);
        }
        $this->payCurrencyCode = $payCurrencyCode;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get paymentTypeCode value
     * @return string|null
     */
    public function getPaymentTypeCode()
    {
        return $this->paymentTypeCode;
    }
    /**
     * Set paymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTypeCode)), __LINE__);
        }
        $this->paymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get agencyCode value
     * @return string|null
     */
    public function getAgencyCode()
    {
        return $this->agencyCode;
    }
    /**
     * Set agencyCode value
     * @param string $agencyCode
     * @return \StructType\AAPNRPaxTransactionType
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCode) && !is_string($agencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyCode)), __LINE__);
        }
        $this->agencyCode = $agencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRPaxTransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
