<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRFlightSegmentType StructType
 * @subpackage Structs
 */
class AAPNRFlightSegmentType extends AbstractStructBase
{
    /**
     * The pnrFltSegRPH
     * @var string
     */
    public $pnrFltSegRPH;
    /**
     * The originAirport
     * @var string
     */
    public $originAirport;
    /**
     * The destinationAirport
     * @var string
     */
    public $destinationAirport;
    /**
     * The classOfService
     * @var string
     */
    public $classOfService;
    /**
     * The carrierCode
     * @var string
     */
    public $carrierCode;
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The departureDatetime
     * @var string
     */
    public $departureDatetime;
    /**
     * The arrivalDatetime
     * @var string
     */
    public $arrivalDatetime;
    /**
     * Constructor method for AAPNRFlightSegmentType
     * @uses AAPNRFlightSegmentType::setPnrFltSegRPH()
     * @uses AAPNRFlightSegmentType::setOriginAirport()
     * @uses AAPNRFlightSegmentType::setDestinationAirport()
     * @uses AAPNRFlightSegmentType::setClassOfService()
     * @uses AAPNRFlightSegmentType::setCarrierCode()
     * @uses AAPNRFlightSegmentType::setFlightNumber()
     * @uses AAPNRFlightSegmentType::setDepartureDatetime()
     * @uses AAPNRFlightSegmentType::setArrivalDatetime()
     * @param string $pnrFltSegRPH
     * @param string $originAirport
     * @param string $destinationAirport
     * @param string $classOfService
     * @param string $carrierCode
     * @param string $flightNumber
     * @param string $departureDatetime
     * @param string $arrivalDatetime
     */
    public function __construct($pnrFltSegRPH = null, $originAirport = null, $destinationAirport = null, $classOfService = null, $carrierCode = null, $flightNumber = null, $departureDatetime = null, $arrivalDatetime = null)
    {
        $this
            ->setPnrFltSegRPH($pnrFltSegRPH)
            ->setOriginAirport($originAirport)
            ->setDestinationAirport($destinationAirport)
            ->setClassOfService($classOfService)
            ->setCarrierCode($carrierCode)
            ->setFlightNumber($flightNumber)
            ->setDepartureDatetime($departureDatetime)
            ->setArrivalDatetime($arrivalDatetime);
    }
    /**
     * Get pnrFltSegRPH value
     * @return string|null
     */
    public function getPnrFltSegRPH()
    {
        return $this->pnrFltSegRPH;
    }
    /**
     * Set pnrFltSegRPH value
     * @param string $pnrFltSegRPH
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setPnrFltSegRPH($pnrFltSegRPH = null)
    {
        // validation for constraint: string
        if (!is_null($pnrFltSegRPH) && !is_string($pnrFltSegRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pnrFltSegRPH)), __LINE__);
        }
        $this->pnrFltSegRPH = $pnrFltSegRPH;
        return $this;
    }
    /**
     * Get originAirport value
     * @return string|null
     */
    public function getOriginAirport()
    {
        return $this->originAirport;
    }
    /**
     * Set originAirport value
     * @param string $originAirport
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setOriginAirport($originAirport = null)
    {
        // validation for constraint: string
        if (!is_null($originAirport) && !is_string($originAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originAirport)), __LINE__);
        }
        $this->originAirport = $originAirport;
        return $this;
    }
    /**
     * Get destinationAirport value
     * @return string|null
     */
    public function getDestinationAirport()
    {
        return $this->destinationAirport;
    }
    /**
     * Set destinationAirport value
     * @param string $destinationAirport
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setDestinationAirport($destinationAirport = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirport) && !is_string($destinationAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAirport)), __LINE__);
        }
        $this->destinationAirport = $destinationAirport;
        return $this;
    }
    /**
     * Get classOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->classOfService;
    }
    /**
     * Set classOfService value
     * @param string $classOfService
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setClassOfService($classOfService = null)
    {
        // validation for constraint: string
        if (!is_null($classOfService) && !is_string($classOfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classOfService)), __LINE__);
        }
        $this->classOfService = $classOfService;
        return $this;
    }
    /**
     * Get carrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }
    /**
     * Set carrierCode value
     * @param string $carrierCode
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->carrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get departureDatetime value
     * @return string|null
     */
    public function getDepartureDatetime()
    {
        return $this->departureDatetime;
    }
    /**
     * Set departureDatetime value
     * @param string $departureDatetime
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setDepartureDatetime($departureDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDatetime) && !is_string($departureDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDatetime)), __LINE__);
        }
        $this->departureDatetime = $departureDatetime;
        return $this;
    }
    /**
     * Get arrivalDatetime value
     * @return string|null
     */
    public function getArrivalDatetime()
    {
        return $this->arrivalDatetime;
    }
    /**
     * Set arrivalDatetime value
     * @param string $arrivalDatetime
     * @return \StructType\AAPNRFlightSegmentType
     */
    public function setArrivalDatetime($arrivalDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDatetime) && !is_string($arrivalDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDatetime)), __LINE__);
        }
        $this->arrivalDatetime = $arrivalDatetime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
