<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAPNRAuditMessagesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Collection of Reservation Audits for a given PNR
 * @subpackage Structs
 */
class AAPNRAuditMessagesType extends AbstractStructBase
{
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: Mandantory booking reference ID
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The PNRAuditMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AAPNRAuditMessageType[]
     */
    public $PNRAuditMessage;
    /**
     * Constructor method for AAPNRAuditMessagesType
     * @uses AAPNRAuditMessagesType::setBookingReferenceID()
     * @uses AAPNRAuditMessagesType::setPNRAuditMessage()
     * @param string $bookingReferenceID
     * @param \StructType\AAPNRAuditMessageType[] $pNRAuditMessage
     */
    public function __construct($bookingReferenceID = null, array $pNRAuditMessage = array())
    {
        $this
            ->setBookingReferenceID($bookingReferenceID)
            ->setPNRAuditMessage($pNRAuditMessage);
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AAPNRAuditMessagesType
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get PNRAuditMessage value
     * @return \StructType\AAPNRAuditMessageType[]|null
     */
    public function getPNRAuditMessage()
    {
        return $this->PNRAuditMessage;
    }
    /**
     * Set PNRAuditMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRAuditMessageType[] $pNRAuditMessage
     * @return \StructType\AAPNRAuditMessagesType
     */
    public function setPNRAuditMessage(array $pNRAuditMessage = array())
    {
        foreach ($pNRAuditMessage as $aAPNRAuditMessagesTypePNRAuditMessageItem) {
            // validation for constraint: itemType
            if (!$aAPNRAuditMessagesTypePNRAuditMessageItem instanceof \StructType\AAPNRAuditMessageType) {
                throw new \InvalidArgumentException(sprintf('The PNRAuditMessage property can only contain items of \StructType\AAPNRAuditMessageType, "%s" given', is_object($aAPNRAuditMessagesTypePNRAuditMessageItem) ? get_class($aAPNRAuditMessagesTypePNRAuditMessageItem) : gettype($aAPNRAuditMessagesTypePNRAuditMessageItem)), __LINE__);
            }
        }
        $this->PNRAuditMessage = $pNRAuditMessage;
        return $this;
    }
    /**
     * Add item to PNRAuditMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRAuditMessageType $item
     * @return \StructType\AAPNRAuditMessagesType
     */
    public function addToPNRAuditMessage(\StructType\AAPNRAuditMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPNRAuditMessageType) {
            throw new \InvalidArgumentException(sprintf('The PNRAuditMessage property can only contain items of \StructType\AAPNRAuditMessageType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PNRAuditMessage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAPNRAuditMessagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
