<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFlightLoadInfoRS StructType
 * Meta informations extracted from the WSDL
 * - type: ns2:AAFlightLoadInfoRS
 * @subpackage Structs
 */
class AAFlightLoadInfoRS extends AbstractStructBase
{
    /**
     * The flightLoadInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAFlightLoadInfo[]
     */
    public $flightLoadInfo;
    /**
     * The successOrError
     * @var \StructType\AAResultType
     */
    public $successOrError;
    /**
     * Constructor method for AAFlightLoadInfoRS
     * @uses AAFlightLoadInfoRS::setFlightLoadInfo()
     * @uses AAFlightLoadInfoRS::setSuccessOrError()
     * @param \StructType\AAFlightLoadInfo[] $flightLoadInfo
     * @param \StructType\AAResultType $successOrError
     */
    public function __construct(array $flightLoadInfo = array(), \StructType\AAResultType $successOrError = null)
    {
        $this
            ->setFlightLoadInfo($flightLoadInfo)
            ->setSuccessOrError($successOrError);
    }
    /**
     * Get flightLoadInfo value
     * @return \StructType\AAFlightLoadInfo[]|null
     */
    public function getFlightLoadInfo()
    {
        return $this->flightLoadInfo;
    }
    /**
     * Set flightLoadInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AAFlightLoadInfo[] $flightLoadInfo
     * @return \StructType\AAFlightLoadInfoRS
     */
    public function setFlightLoadInfo(array $flightLoadInfo = array())
    {
        foreach ($flightLoadInfo as $aAFlightLoadInfoRSFlightLoadInfoItem) {
            // validation for constraint: itemType
            if (!$aAFlightLoadInfoRSFlightLoadInfoItem instanceof \StructType\AAFlightLoadInfo) {
                throw new \InvalidArgumentException(sprintf('The flightLoadInfo property can only contain items of \StructType\AAFlightLoadInfo, "%s" given', is_object($aAFlightLoadInfoRSFlightLoadInfoItem) ? get_class($aAFlightLoadInfoRSFlightLoadInfoItem) : gettype($aAFlightLoadInfoRSFlightLoadInfoItem)), __LINE__);
            }
        }
        $this->flightLoadInfo = $flightLoadInfo;
        return $this;
    }
    /**
     * Add item to flightLoadInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AAFlightLoadInfo $item
     * @return \StructType\AAFlightLoadInfoRS
     */
    public function addToFlightLoadInfo(\StructType\AAFlightLoadInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAFlightLoadInfo) {
            throw new \InvalidArgumentException(sprintf('The flightLoadInfo property can only contain items of \StructType\AAFlightLoadInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->flightLoadInfo[] = $item;
        return $this;
    }
    /**
     * Get successOrError value
     * @return \StructType\AAResultType|null
     */
    public function getSuccessOrError()
    {
        return $this->successOrError;
    }
    /**
     * Set successOrError value
     * @param \StructType\AAResultType $successOrError
     * @return \StructType\AAFlightLoadInfoRS
     */
    public function setSuccessOrError(\StructType\AAResultType $successOrError = null)
    {
        $this->successOrError = $successOrError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFlightLoadInfoRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
