<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFlightLoadInfo StructType
 * @subpackage Structs
 */
class AAFlightLoadInfo extends AbstractStructBase
{
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The departureDate
     * @var string
     */
    public $departureDate;
    /**
     * The aircraftModel
     * @var string
     */
    public $aircraftModel;
    /**
     * The cabinInventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AACabinInventoryType[]
     */
    public $cabinInventory;
    /**
     * Constructor method for AAFlightLoadInfo
     * @uses AAFlightLoadInfo::setFlightNumber()
     * @uses AAFlightLoadInfo::setDepartureDate()
     * @uses AAFlightLoadInfo::setAircraftModel()
     * @uses AAFlightLoadInfo::setCabinInventory()
     * @param string $flightNumber
     * @param string $departureDate
     * @param string $aircraftModel
     * @param \StructType\AACabinInventoryType[] $cabinInventory
     */
    public function __construct($flightNumber = null, $departureDate = null, $aircraftModel = null, array $cabinInventory = array())
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setDepartureDate($departureDate)
            ->setAircraftModel($aircraftModel)
            ->setCabinInventory($cabinInventory);
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AAFlightLoadInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get departureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }
    /**
     * Set departureDate value
     * @param string $departureDate
     * @return \StructType\AAFlightLoadInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->departureDate = $departureDate;
        return $this;
    }
    /**
     * Get aircraftModel value
     * @return string|null
     */
    public function getAircraftModel()
    {
        return $this->aircraftModel;
    }
    /**
     * Set aircraftModel value
     * @param string $aircraftModel
     * @return \StructType\AAFlightLoadInfo
     */
    public function setAircraftModel($aircraftModel = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftModel) && !is_string($aircraftModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aircraftModel)), __LINE__);
        }
        $this->aircraftModel = $aircraftModel;
        return $this;
    }
    /**
     * Get cabinInventory value
     * @return \StructType\AACabinInventoryType[]|null
     */
    public function getCabinInventory()
    {
        return $this->cabinInventory;
    }
    /**
     * Set cabinInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\AACabinInventoryType[] $cabinInventory
     * @return \StructType\AAFlightLoadInfo
     */
    public function setCabinInventory(array $cabinInventory = array())
    {
        foreach ($cabinInventory as $aAFlightLoadInfoCabinInventoryItem) {
            // validation for constraint: itemType
            if (!$aAFlightLoadInfoCabinInventoryItem instanceof \StructType\AACabinInventoryType) {
                throw new \InvalidArgumentException(sprintf('The cabinInventory property can only contain items of \StructType\AACabinInventoryType, "%s" given', is_object($aAFlightLoadInfoCabinInventoryItem) ? get_class($aAFlightLoadInfoCabinInventoryItem) : gettype($aAFlightLoadInfoCabinInventoryItem)), __LINE__);
            }
        }
        $this->cabinInventory = $cabinInventory;
        return $this;
    }
    /**
     * Add item to cabinInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\AACabinInventoryType $item
     * @return \StructType\AAFlightLoadInfo
     */
    public function addToCabinInventory(\StructType\AACabinInventoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AACabinInventoryType) {
            throw new \InvalidArgumentException(sprintf('The cabinInventory property can only contain items of \StructType\AACabinInventoryType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cabinInventory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFlightLoadInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
