<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFlightInventoryDataRS StructType
 * Meta informations extracted from the WSDL
 * - type: ns3:AAFlightInventoryDataRS
 * @subpackage Structs
 */
class AAFlightInventoryDataRS extends AbstractStructBase
{
    /**
     * The segmentSeatInventories
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AASegmentSeatInventoriesType[]
     */
    public $segmentSeatInventories;
    /**
     * The statusErrorsAndWarnings
     * @var \StructType\AAStatusErrorsAndWarnings
     */
    public $statusErrorsAndWarnings;
    /**
     * The UserId
     * @var string
     */
    public $UserId;
    /**
     * The ChannelId
     * @var string
     */
    public $ChannelId;
    /**
     * Constructor method for AAFlightInventoryDataRS
     * @uses AAFlightInventoryDataRS::setSegmentSeatInventories()
     * @uses AAFlightInventoryDataRS::setStatusErrorsAndWarnings()
     * @uses AAFlightInventoryDataRS::setUserId()
     * @uses AAFlightInventoryDataRS::setChannelId()
     * @param \StructType\AASegmentSeatInventoriesType[] $segmentSeatInventories
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @param string $userId
     * @param string $channelId
     */
    public function __construct(array $segmentSeatInventories = array(), \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null, $userId = null, $channelId = null)
    {
        $this
            ->setSegmentSeatInventories($segmentSeatInventories)
            ->setStatusErrorsAndWarnings($statusErrorsAndWarnings)
            ->setUserId($userId)
            ->setChannelId($channelId);
    }
    /**
     * Get segmentSeatInventories value
     * @return \StructType\AASegmentSeatInventoriesType[]|null
     */
    public function getSegmentSeatInventories()
    {
        return $this->segmentSeatInventories;
    }
    /**
     * Set segmentSeatInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\AASegmentSeatInventoriesType[] $segmentSeatInventories
     * @return \StructType\AAFlightInventoryDataRS
     */
    public function setSegmentSeatInventories(array $segmentSeatInventories = array())
    {
        foreach ($segmentSeatInventories as $aAFlightInventoryDataRSSegmentSeatInventoriesItem) {
            // validation for constraint: itemType
            if (!$aAFlightInventoryDataRSSegmentSeatInventoriesItem instanceof \StructType\AASegmentSeatInventoriesType) {
                throw new \InvalidArgumentException(sprintf('The segmentSeatInventories property can only contain items of \StructType\AASegmentSeatInventoriesType, "%s" given', is_object($aAFlightInventoryDataRSSegmentSeatInventoriesItem) ? get_class($aAFlightInventoryDataRSSegmentSeatInventoriesItem) : gettype($aAFlightInventoryDataRSSegmentSeatInventoriesItem)), __LINE__);
            }
        }
        $this->segmentSeatInventories = $segmentSeatInventories;
        return $this;
    }
    /**
     * Add item to segmentSeatInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\AASegmentSeatInventoriesType $item
     * @return \StructType\AAFlightInventoryDataRS
     */
    public function addToSegmentSeatInventories(\StructType\AASegmentSeatInventoriesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AASegmentSeatInventoriesType) {
            throw new \InvalidArgumentException(sprintf('The segmentSeatInventories property can only contain items of \StructType\AASegmentSeatInventoriesType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->segmentSeatInventories[] = $item;
        return $this;
    }
    /**
     * Get statusErrorsAndWarnings value
     * @return \StructType\AAStatusErrorsAndWarnings|null
     */
    public function getStatusErrorsAndWarnings()
    {
        return $this->statusErrorsAndWarnings;
    }
    /**
     * Set statusErrorsAndWarnings value
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @return \StructType\AAFlightInventoryDataRS
     */
    public function setStatusErrorsAndWarnings(\StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null)
    {
        $this->statusErrorsAndWarnings = $statusErrorsAndWarnings;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\AAFlightInventoryDataRS
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get ChannelId value
     * @return string|null
     */
    public function getChannelId()
    {
        return $this->ChannelId;
    }
    /**
     * Set ChannelId value
     * @param string $channelId
     * @return \StructType\AAFlightInventoryDataRS
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channelId)), __LINE__);
        }
        $this->ChannelId = $channelId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFlightInventoryDataRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
