<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFlightInvRS StructType
 * @subpackage Structs
 */
class AAFlightInvRS extends AbstractStructBase
{
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * The depatureDate
     * @var string
     */
    public $depatureDate;
    /**
     * The cabinClass
     * @var string
     */
    public $cabinClass;
    /**
     * The statusErrorsAndWarnings
     * @var \StructType\AAStatusErrorsAndWarnings
     */
    public $statusErrorsAndWarnings;
    /**
     * Constructor method for AAFlightInvRS
     * @uses AAFlightInvRS::setFlightNumber()
     * @uses AAFlightInvRS::setSegmentCode()
     * @uses AAFlightInvRS::setDepatureDate()
     * @uses AAFlightInvRS::setCabinClass()
     * @uses AAFlightInvRS::setStatusErrorsAndWarnings()
     * @param string $flightNumber
     * @param string $segmentCode
     * @param string $depatureDate
     * @param string $cabinClass
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     */
    public function __construct($flightNumber = null, $segmentCode = null, $depatureDate = null, $cabinClass = null, \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setSegmentCode($segmentCode)
            ->setDepatureDate($depatureDate)
            ->setCabinClass($cabinClass)
            ->setStatusErrorsAndWarnings($statusErrorsAndWarnings);
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AAFlightInvRS
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AAFlightInvRS
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get depatureDate value
     * @return string|null
     */
    public function getDepatureDate()
    {
        return $this->depatureDate;
    }
    /**
     * Set depatureDate value
     * @param string $depatureDate
     * @return \StructType\AAFlightInvRS
     */
    public function setDepatureDate($depatureDate = null)
    {
        // validation for constraint: string
        if (!is_null($depatureDate) && !is_string($depatureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depatureDate)), __LINE__);
        }
        $this->depatureDate = $depatureDate;
        return $this;
    }
    /**
     * Get cabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->cabinClass;
    }
    /**
     * Set cabinClass value
     * @param string $cabinClass
     * @return \StructType\AAFlightInvRS
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinClass)), __LINE__);
        }
        $this->cabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get statusErrorsAndWarnings value
     * @return \StructType\AAStatusErrorsAndWarnings|null
     */
    public function getStatusErrorsAndWarnings()
    {
        return $this->statusErrorsAndWarnings;
    }
    /**
     * Set statusErrorsAndWarnings value
     * @param \StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings
     * @return \StructType\AAFlightInvRS
     */
    public function setStatusErrorsAndWarnings(\StructType\AAStatusErrorsAndWarnings $statusErrorsAndWarnings = null)
    {
        $this->statusErrorsAndWarnings = $statusErrorsAndWarnings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFlightInvRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
