<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFeeType StructType
 * @subpackage Structs
 */
class AAFeeType extends AbstractStructBase
{
    /**
     * The feeCode
     * @var string
     */
    public $feeCode;
    /**
     * The taxName
     * @var string
     */
    public $taxName;
    /**
     * Constructor method for AAFeeType
     * @uses AAFeeType::setFeeCode()
     * @uses AAFeeType::setTaxName()
     * @param string $feeCode
     * @param string $taxName
     */
    public function __construct($feeCode = null, $taxName = null)
    {
        $this
            ->setFeeCode($feeCode)
            ->setTaxName($taxName);
    }
    /**
     * Get feeCode value
     * @return string|null
     */
    public function getFeeCode()
    {
        return $this->feeCode;
    }
    /**
     * Set feeCode value
     * @param string $feeCode
     * @return \StructType\AAFeeType
     */
    public function setFeeCode($feeCode = null)
    {
        // validation for constraint: string
        if (!is_null($feeCode) && !is_string($feeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeCode)), __LINE__);
        }
        $this->feeCode = $feeCode;
        return $this;
    }
    /**
     * Get taxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->taxName;
    }
    /**
     * Set taxName value
     * @param string $taxName
     * @return \StructType\AAFeeType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxName)), __LINE__);
        }
        $this->taxName = $taxName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
