<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFareType StructType
 * @subpackage Structs
 */
class AAFareType extends AbstractStructBase
{
    /**
     * The adultFareAmount
     * @var float
     */
    public $adultFareAmount;
    /**
     * The infantFareAmount
     * @var float
     */
    public $infantFareAmount;
    /**
     * The childFareAmount
     * @var float
     */
    public $childFareAmount;
    /**
     * The fareBasisCode
     * @var string
     */
    public $fareBasisCode;
    /**
     * Constructor method for AAFareType
     * @uses AAFareType::setAdultFareAmount()
     * @uses AAFareType::setInfantFareAmount()
     * @uses AAFareType::setChildFareAmount()
     * @uses AAFareType::setFareBasisCode()
     * @param float $adultFareAmount
     * @param float $infantFareAmount
     * @param float $childFareAmount
     * @param string $fareBasisCode
     */
    public function __construct($adultFareAmount = null, $infantFareAmount = null, $childFareAmount = null, $fareBasisCode = null)
    {
        $this
            ->setAdultFareAmount($adultFareAmount)
            ->setInfantFareAmount($infantFareAmount)
            ->setChildFareAmount($childFareAmount)
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get adultFareAmount value
     * @return float|null
     */
    public function getAdultFareAmount()
    {
        return $this->adultFareAmount;
    }
    /**
     * Set adultFareAmount value
     * @param float $adultFareAmount
     * @return \StructType\AAFareType
     */
    public function setAdultFareAmount($adultFareAmount = null)
    {
        $this->adultFareAmount = $adultFareAmount;
        return $this;
    }
    /**
     * Get infantFareAmount value
     * @return float|null
     */
    public function getInfantFareAmount()
    {
        return $this->infantFareAmount;
    }
    /**
     * Set infantFareAmount value
     * @param float $infantFareAmount
     * @return \StructType\AAFareType
     */
    public function setInfantFareAmount($infantFareAmount = null)
    {
        $this->infantFareAmount = $infantFareAmount;
        return $this;
    }
    /**
     * Get childFareAmount value
     * @return float|null
     */
    public function getChildFareAmount()
    {
        return $this->childFareAmount;
    }
    /**
     * Set childFareAmount value
     * @param float $childFareAmount
     * @return \StructType\AAFareType
     */
    public function setChildFareAmount($childFareAmount = null)
    {
        $this->childFareAmount = $childFareAmount;
        return $this;
    }
    /**
     * Get fareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->fareBasisCode;
    }
    /**
     * Set fareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\AAFareType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasisCode)), __LINE__);
        }
        $this->fareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
