<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAFCCSegBCInventoryUpdate StructType
 * @subpackage Structs
 */
class AAFCCSegBCInventoryUpdate extends AbstractStructBase
{
    /**
     * The bookingCode
     * @var string
     */
    public $bookingCode;
    /**
     * The adultFareAmount
     * @var float
     */
    public $adultFareAmount;
    /**
     * The fareType
     * @var string
     */
    public $fareType;
    /**
     * The allocatedSeats
     * @var int
     */
    public $allocatedSeats;
    /**
     * The priorityFlag
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $priorityFlag;
    /**
     * The availableSeats
     * @var int
     */
    public $availableSeats;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for AAFCCSegBCInventoryUpdate
     * @uses AAFCCSegBCInventoryUpdate::setBookingCode()
     * @uses AAFCCSegBCInventoryUpdate::setAdultFareAmount()
     * @uses AAFCCSegBCInventoryUpdate::setFareType()
     * @uses AAFCCSegBCInventoryUpdate::setAllocatedSeats()
     * @uses AAFCCSegBCInventoryUpdate::setPriorityFlag()
     * @uses AAFCCSegBCInventoryUpdate::setAvailableSeats()
     * @uses AAFCCSegBCInventoryUpdate::setStatus()
     * @param string $bookingCode
     * @param float $adultFareAmount
     * @param string $fareType
     * @param int $allocatedSeats
     * @param bool $priorityFlag
     * @param int $availableSeats
     * @param string $status
     */
    public function __construct($bookingCode = null, $adultFareAmount = null, $fareType = null, $allocatedSeats = null, $priorityFlag = null, $availableSeats = null, $status = null)
    {
        $this
            ->setBookingCode($bookingCode)
            ->setAdultFareAmount($adultFareAmount)
            ->setFareType($fareType)
            ->setAllocatedSeats($allocatedSeats)
            ->setPriorityFlag($priorityFlag)
            ->setAvailableSeats($availableSeats)
            ->setStatus($status);
    }
    /**
     * Get bookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->bookingCode;
    }
    /**
     * Set bookingCode value
     * @param string $bookingCode
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingCode)), __LINE__);
        }
        $this->bookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get adultFareAmount value
     * @return float|null
     */
    public function getAdultFareAmount()
    {
        return $this->adultFareAmount;
    }
    /**
     * Set adultFareAmount value
     * @param float $adultFareAmount
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setAdultFareAmount($adultFareAmount = null)
    {
        $this->adultFareAmount = $adultFareAmount;
        return $this;
    }
    /**
     * Get fareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->fareType;
    }
    /**
     * Set fareType value
     * @param string $fareType
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->fareType = $fareType;
        return $this;
    }
    /**
     * Get allocatedSeats value
     * @return int|null
     */
    public function getAllocatedSeats()
    {
        return $this->allocatedSeats;
    }
    /**
     * Set allocatedSeats value
     * @param int $allocatedSeats
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setAllocatedSeats($allocatedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedSeats) && !is_numeric($allocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allocatedSeats)), __LINE__);
        }
        $this->allocatedSeats = $allocatedSeats;
        return $this;
    }
    /**
     * Get priorityFlag value
     * @return bool|null
     */
    public function getPriorityFlag()
    {
        return $this->priorityFlag;
    }
    /**
     * Set priorityFlag value
     * @param bool $priorityFlag
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setPriorityFlag($priorityFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($priorityFlag) && !is_bool($priorityFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priorityFlag)), __LINE__);
        }
        $this->priorityFlag = $priorityFlag;
        return $this;
    }
    /**
     * Get availableSeats value
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return $this->availableSeats;
    }
    /**
     * Set availableSeats value
     * @param int $availableSeats
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !is_numeric($availableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableSeats)), __LINE__);
        }
        $this->availableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAFCCSegBCInventoryUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
