<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AACnxModAddONDBalancesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Pricing info summary on OND for mod/cnx/add.
 * @subpackage Structs
 */
class AACnxModAddONDBalancesType extends AbstractStructBase
{
    /**
     * The Fare
     * @var \StructType\AACurrencyAmountType
     */
    public $Fare;
    /**
     * The TaxAndSurcharge
     * @var \StructType\AACurrencyAmountType
     */
    public $TaxAndSurcharge;
    /**
     * The Adjustments
     * @var \StructType\AACurrencyAmountType
     */
    public $Adjustments;
    /**
     * The OtherCharges
     * Meta informations extracted from the WSDL
     * - documentation: Existing cancellation + modification charges
     * @var \StructType\AACurrencyAmountType
     */
    public $OtherCharges;
    /**
     * The TotalCharges
     * Meta informations extracted from the WSDL
     * - documentation: Sum of Fare, TaxAndSurcharge, Adjustment and OtherCharges
     * @var \StructType\AACurrencyAmountType
     */
    public $TotalCharges;
    /**
     * The NonRefundableAmount
     * @var \StructType\AACurrencyAmountType
     */
    public $NonRefundableAmount;
    /**
     * The RefundableAmount
     * @var \StructType\AACurrencyAmountType
     */
    public $RefundableAmount;
    /**
     * Constructor method for AACnxModAddONDBalancesType
     * @uses AACnxModAddONDBalancesType::setFare()
     * @uses AACnxModAddONDBalancesType::setTaxAndSurcharge()
     * @uses AACnxModAddONDBalancesType::setAdjustments()
     * @uses AACnxModAddONDBalancesType::setOtherCharges()
     * @uses AACnxModAddONDBalancesType::setTotalCharges()
     * @uses AACnxModAddONDBalancesType::setNonRefundableAmount()
     * @uses AACnxModAddONDBalancesType::setRefundableAmount()
     * @param \StructType\AACurrencyAmountType $fare
     * @param \StructType\AACurrencyAmountType $taxAndSurcharge
     * @param \StructType\AACurrencyAmountType $adjustments
     * @param \StructType\AACurrencyAmountType $otherCharges
     * @param \StructType\AACurrencyAmountType $totalCharges
     * @param \StructType\AACurrencyAmountType $nonRefundableAmount
     * @param \StructType\AACurrencyAmountType $refundableAmount
     */
    public function __construct(\StructType\AACurrencyAmountType $fare = null, \StructType\AACurrencyAmountType $taxAndSurcharge = null, \StructType\AACurrencyAmountType $adjustments = null, \StructType\AACurrencyAmountType $otherCharges = null, \StructType\AACurrencyAmountType $totalCharges = null, \StructType\AACurrencyAmountType $nonRefundableAmount = null, \StructType\AACurrencyAmountType $refundableAmount = null)
    {
        $this
            ->setFare($fare)
            ->setTaxAndSurcharge($taxAndSurcharge)
            ->setAdjustments($adjustments)
            ->setOtherCharges($otherCharges)
            ->setTotalCharges($totalCharges)
            ->setNonRefundableAmount($nonRefundableAmount)
            ->setRefundableAmount($refundableAmount);
    }
    /**
     * Get Fare value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \StructType\AACurrencyAmountType $fare
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setFare(\StructType\AACurrencyAmountType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get TaxAndSurcharge value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTaxAndSurcharge()
    {
        return $this->TaxAndSurcharge;
    }
    /**
     * Set TaxAndSurcharge value
     * @param \StructType\AACurrencyAmountType $taxAndSurcharge
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setTaxAndSurcharge(\StructType\AACurrencyAmountType $taxAndSurcharge = null)
    {
        $this->TaxAndSurcharge = $taxAndSurcharge;
        return $this;
    }
    /**
     * Get Adjustments value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getAdjustments()
    {
        return $this->Adjustments;
    }
    /**
     * Set Adjustments value
     * @param \StructType\AACurrencyAmountType $adjustments
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setAdjustments(\StructType\AACurrencyAmountType $adjustments = null)
    {
        $this->Adjustments = $adjustments;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param \StructType\AACurrencyAmountType $otherCharges
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setOtherCharges(\StructType\AACurrencyAmountType $otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param \StructType\AACurrencyAmountType $totalCharges
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setTotalCharges(\StructType\AACurrencyAmountType $totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get NonRefundableAmount value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getNonRefundableAmount()
    {
        return $this->NonRefundableAmount;
    }
    /**
     * Set NonRefundableAmount value
     * @param \StructType\AACurrencyAmountType $nonRefundableAmount
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setNonRefundableAmount(\StructType\AACurrencyAmountType $nonRefundableAmount = null)
    {
        $this->NonRefundableAmount = $nonRefundableAmount;
        return $this;
    }
    /**
     * Get RefundableAmount value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getRefundableAmount()
    {
        return $this->RefundableAmount;
    }
    /**
     * Set RefundableAmount value
     * @param \StructType\AACurrencyAmountType $refundableAmount
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public function setRefundableAmount(\StructType\AACurrencyAmountType $refundableAmount = null)
    {
        $this->RefundableAmount = $refundableAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AACnxModAddONDBalancesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
