<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AACabinInventoryType StructType
 * @subpackage Structs
 */
class AACabinInventoryType extends AbstractStructBase
{
    /**
     * The cabinClass
     * @var string
     */
    public $cabinClass;
    /**
     * The segmentInventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AASegmentInventoryType[]
     */
    public $segmentInventory;
    /**
     * Constructor method for AACabinInventoryType
     * @uses AACabinInventoryType::setCabinClass()
     * @uses AACabinInventoryType::setSegmentInventory()
     * @param string $cabinClass
     * @param \StructType\AASegmentInventoryType[] $segmentInventory
     */
    public function __construct($cabinClass = null, array $segmentInventory = array())
    {
        $this
            ->setCabinClass($cabinClass)
            ->setSegmentInventory($segmentInventory);
    }
    /**
     * Get cabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->cabinClass;
    }
    /**
     * Set cabinClass value
     * @param string $cabinClass
     * @return \StructType\AACabinInventoryType
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinClass)), __LINE__);
        }
        $this->cabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get segmentInventory value
     * @return \StructType\AASegmentInventoryType[]|null
     */
    public function getSegmentInventory()
    {
        return $this->segmentInventory;
    }
    /**
     * Set segmentInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\AASegmentInventoryType[] $segmentInventory
     * @return \StructType\AACabinInventoryType
     */
    public function setSegmentInventory(array $segmentInventory = array())
    {
        foreach ($segmentInventory as $aACabinInventoryTypeSegmentInventoryItem) {
            // validation for constraint: itemType
            if (!$aACabinInventoryTypeSegmentInventoryItem instanceof \StructType\AASegmentInventoryType) {
                throw new \InvalidArgumentException(sprintf('The segmentInventory property can only contain items of \StructType\AASegmentInventoryType, "%s" given', is_object($aACabinInventoryTypeSegmentInventoryItem) ? get_class($aACabinInventoryTypeSegmentInventoryItem) : gettype($aACabinInventoryTypeSegmentInventoryItem)), __LINE__);
            }
        }
        $this->segmentInventory = $segmentInventory;
        return $this;
    }
    /**
     * Add item to segmentInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\AASegmentInventoryType $item
     * @return \StructType\AACabinInventoryType
     */
    public function addToSegmentInventory(\StructType\AASegmentInventoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AASegmentInventoryType) {
            throw new \InvalidArgumentException(sprintf('The segmentInventory property can only contain items of \StructType\AASegmentInventoryType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->segmentInventory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AACabinInventoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
