<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AABundledServiceExt StructType
 * @subpackage Structs
 */
class AABundledServiceExt extends AbstractStructBase
{
    /**
     * The bundledService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $bundledService;
    /**
     * The applicableOnd
     * Meta informations extracted from the WSDL
     * - documentation: Bundled Service Applicable Ond Code
     * - use: optional
     * @var string
     */
    public $applicableOnd;
    /**
     * The applicableOndSequence
     * Meta informations extracted from the WSDL
     * - documentation: Bundled Service Applicable Ond Code
     * - use: optional
     * @var int
     */
    public $applicableOndSequence;
    /**
     * Constructor method for AABundledServiceExt
     * @uses AABundledServiceExt::setBundledService()
     * @uses AABundledServiceExt::setApplicableOnd()
     * @uses AABundledServiceExt::setApplicableOndSequence()
     * @param mixed[] $bundledService
     * @param string $applicableOnd
     * @param int $applicableOndSequence
     */
    public function __construct(array $bundledService = array(), $applicableOnd = null, $applicableOndSequence = null)
    {
        $this
            ->setBundledService($bundledService)
            ->setApplicableOnd($applicableOnd)
            ->setApplicableOndSequence($applicableOndSequence);
    }
    /**
     * Get bundledService value
     * @return mixed[]|null
     */
    public function getBundledService()
    {
        return $this->bundledService;
    }
    /**
     * Set bundledService value
     * @throws \InvalidArgumentException
     * @param mixed[] $bundledService
     * @return \StructType\AABundledServiceExt
     */
    public function setBundledService(array $bundledService = array())
    {
        foreach ($bundledService as $aABundledServiceExtBundledServiceItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The bundledService property can only contain items of anyType, "%s" given', is_object($aABundledServiceExtBundledServiceItem) ? get_class($aABundledServiceExtBundledServiceItem) : gettype($aABundledServiceExtBundledServiceItem)), __LINE__);
            }
        }
        $this->bundledService = $bundledService;
        return $this;
    }
    /**
     * Add item to bundledService value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AABundledServiceExt
     */
    public function addToBundledService($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The bundledService property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bundledService[] = $item;
        return $this;
    }
    /**
     * Get applicableOnd value
     * @return string|null
     */
    public function getApplicableOnd()
    {
        return $this->applicableOnd;
    }
    /**
     * Set applicableOnd value
     * @param string $applicableOnd
     * @return \StructType\AABundledServiceExt
     */
    public function setApplicableOnd($applicableOnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableOnd) && !is_string($applicableOnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicableOnd)), __LINE__);
        }
        $this->applicableOnd = $applicableOnd;
        return $this;
    }
    /**
     * Get applicableOndSequence value
     * @return int|null
     */
    public function getApplicableOndSequence()
    {
        return $this->applicableOndSequence;
    }
    /**
     * Set applicableOndSequence value
     * @param int $applicableOndSequence
     * @return \StructType\AABundledServiceExt
     */
    public function setApplicableOndSequence($applicableOndSequence = null)
    {
        // validation for constraint: int
        if (!is_null($applicableOndSequence) && !is_numeric($applicableOndSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicableOndSequence)), __LINE__);
        }
        $this->applicableOndSequence = $applicableOndSequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AABundledServiceExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
