<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AABookingCategoryType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Booking type
 * @subpackage Structs
 */
class AABookingCategoryType extends AbstractStructBase
{
    /**
     * The TypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Booking category type code
     * @var string
     */
    public $TypeCode;
    /**
     * The TypeName
     * Meta informations extracted from the WSDL
     * - documentation: Booking category type name
     * @var string
     */
    public $TypeName;
    /**
     * Constructor method for AABookingCategoryType
     * @uses AABookingCategoryType::setTypeCode()
     * @uses AABookingCategoryType::setTypeName()
     * @param string $typeCode
     * @param string $typeName
     */
    public function __construct($typeCode = null, $typeName = null)
    {
        $this
            ->setTypeCode($typeCode)
            ->setTypeName($typeName);
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\AABookingCategoryType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get TypeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->TypeName;
    }
    /**
     * Set TypeName value
     * @param string $typeName
     * @return \StructType\AABookingCategoryType
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeName)), __LINE__);
        }
        $this->TypeName = $typeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AABookingCategoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
