<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAirReservationExt StructType
 * Meta informations extracted from the WSDL
 * - documentation: AccelAero Extensions for OTA AirReservationType, which is included as TPA_Extension
 * @subpackage Structs
 */
class AAAirReservationExt extends AbstractStructBase
{
    /**
     * The ResAccountSummary
     * Meta informations extracted from the WSDL
     * - documentation: Reservation Account Summary (total payments, total balances and total credits)
     * - minOccurs: 0
     * @var \StructType\AAResAccSummaryType
     */
    public $ResAccountSummary;
    /**
     * The UserNotes
     * Meta informations extracted from the WSDL
     * - documentation: Free Text Notes
     * - minOccurs: 0
     * @var \StructType\AAUserNotesType
     */
    public $UserNotes;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - documentation: Reservation contact information
     * - minOccurs: 0
     * @var \StructType\AAContactInfoType
     */
    public $ContactInfo;
    /**
     * The AlterationBalances
     * Meta informations extracted from the WSDL
     * - documentation: Balance amounts in doing reservation modifications
     * - minOccurs: 0
     * @var \StructType\AAAlterationBalancesType
     */
    public $AlterationBalances;
    /**
     * The CurrentExtPayTxInfo
     * Meta informations extracted from the WSDL
     * - documentation: External Payment Transaction Information.
     * - minOccurs: 0
     * @var \StructType\AAExternalPayTxType
     */
    public $CurrentExtPayTxInfo;
    /**
     * The AdminInfo
     * Meta informations extracted from the WSDL
     * - documentation: reservation Admin Information.
     * - minOccurs: 0
     * @var \StructType\AAAdminInfoType
     */
    public $AdminInfo;
    /**
     * The ResSummary
     * Meta informations extracted from the WSDL
     * - documentation: Reservation Summary.
     * - minOccurs: 0
     * @var \StructType\AAResSummaryType
     */
    public $ResSummary;
    /**
     * The TravelerAdditionalInfo
     * Meta informations extracted from the WSDL
     * - documentation: Travellers Additional Information
     * - minOccurs: 0
     * @var \StructType\AATravelerInfoType
     */
    public $TravelerAdditionalInfo;
    /**
     * Constructor method for AAAirReservationExt
     * @uses AAAirReservationExt::setResAccountSummary()
     * @uses AAAirReservationExt::setUserNotes()
     * @uses AAAirReservationExt::setContactInfo()
     * @uses AAAirReservationExt::setAlterationBalances()
     * @uses AAAirReservationExt::setCurrentExtPayTxInfo()
     * @uses AAAirReservationExt::setAdminInfo()
     * @uses AAAirReservationExt::setResSummary()
     * @uses AAAirReservationExt::setTravelerAdditionalInfo()
     * @param \StructType\AAResAccSummaryType $resAccountSummary
     * @param \StructType\AAUserNotesType $userNotes
     * @param \StructType\AAContactInfoType $contactInfo
     * @param \StructType\AAAlterationBalancesType $alterationBalances
     * @param \StructType\AAExternalPayTxType $currentExtPayTxInfo
     * @param \StructType\AAAdminInfoType $adminInfo
     * @param \StructType\AAResSummaryType $resSummary
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     */
    public function __construct(\StructType\AAResAccSummaryType $resAccountSummary = null, \StructType\AAUserNotesType $userNotes = null, \StructType\AAContactInfoType $contactInfo = null, \StructType\AAAlterationBalancesType $alterationBalances = null, \StructType\AAExternalPayTxType $currentExtPayTxInfo = null, \StructType\AAAdminInfoType $adminInfo = null, \StructType\AAResSummaryType $resSummary = null, \StructType\AATravelerInfoType $travelerAdditionalInfo = null)
    {
        $this
            ->setResAccountSummary($resAccountSummary)
            ->setUserNotes($userNotes)
            ->setContactInfo($contactInfo)
            ->setAlterationBalances($alterationBalances)
            ->setCurrentExtPayTxInfo($currentExtPayTxInfo)
            ->setAdminInfo($adminInfo)
            ->setResSummary($resSummary)
            ->setTravelerAdditionalInfo($travelerAdditionalInfo);
    }
    /**
     * Get ResAccountSummary value
     * @return \StructType\AAResAccSummaryType|null
     */
    public function getResAccountSummary()
    {
        return $this->ResAccountSummary;
    }
    /**
     * Set ResAccountSummary value
     * @param \StructType\AAResAccSummaryType $resAccountSummary
     * @return \StructType\AAAirReservationExt
     */
    public function setResAccountSummary(\StructType\AAResAccSummaryType $resAccountSummary = null)
    {
        $this->ResAccountSummary = $resAccountSummary;
        return $this;
    }
    /**
     * Get UserNotes value
     * @return \StructType\AAUserNotesType|null
     */
    public function getUserNotes()
    {
        return $this->UserNotes;
    }
    /**
     * Set UserNotes value
     * @param \StructType\AAUserNotesType $userNotes
     * @return \StructType\AAAirReservationExt
     */
    public function setUserNotes(\StructType\AAUserNotesType $userNotes = null)
    {
        $this->UserNotes = $userNotes;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\AAContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\AAContactInfoType $contactInfo
     * @return \StructType\AAAirReservationExt
     */
    public function setContactInfo(\StructType\AAContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get AlterationBalances value
     * @return \StructType\AAAlterationBalancesType|null
     */
    public function getAlterationBalances()
    {
        return $this->AlterationBalances;
    }
    /**
     * Set AlterationBalances value
     * @param \StructType\AAAlterationBalancesType $alterationBalances
     * @return \StructType\AAAirReservationExt
     */
    public function setAlterationBalances(\StructType\AAAlterationBalancesType $alterationBalances = null)
    {
        $this->AlterationBalances = $alterationBalances;
        return $this;
    }
    /**
     * Get CurrentExtPayTxInfo value
     * @return \StructType\AAExternalPayTxType|null
     */
    public function getCurrentExtPayTxInfo()
    {
        return $this->CurrentExtPayTxInfo;
    }
    /**
     * Set CurrentExtPayTxInfo value
     * @param \StructType\AAExternalPayTxType $currentExtPayTxInfo
     * @return \StructType\AAAirReservationExt
     */
    public function setCurrentExtPayTxInfo(\StructType\AAExternalPayTxType $currentExtPayTxInfo = null)
    {
        $this->CurrentExtPayTxInfo = $currentExtPayTxInfo;
        return $this;
    }
    /**
     * Get AdminInfo value
     * @return \StructType\AAAdminInfoType|null
     */
    public function getAdminInfo()
    {
        return $this->AdminInfo;
    }
    /**
     * Set AdminInfo value
     * @param \StructType\AAAdminInfoType $adminInfo
     * @return \StructType\AAAirReservationExt
     */
    public function setAdminInfo(\StructType\AAAdminInfoType $adminInfo = null)
    {
        $this->AdminInfo = $adminInfo;
        return $this;
    }
    /**
     * Get ResSummary value
     * @return \StructType\AAResSummaryType|null
     */
    public function getResSummary()
    {
        return $this->ResSummary;
    }
    /**
     * Set ResSummary value
     * @param \StructType\AAResSummaryType $resSummary
     * @return \StructType\AAAirReservationExt
     */
    public function setResSummary(\StructType\AAResSummaryType $resSummary = null)
    {
        $this->ResSummary = $resSummary;
        return $this;
    }
    /**
     * Get TravelerAdditionalInfo value
     * @return \StructType\AATravelerInfoType|null
     */
    public function getTravelerAdditionalInfo()
    {
        return $this->TravelerAdditionalInfo;
    }
    /**
     * Set TravelerAdditionalInfo value
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     * @return \StructType\AAAirReservationExt
     */
    public function setTravelerAdditionalInfo(\StructType\AATravelerInfoType $travelerAdditionalInfo = null)
    {
        $this->TravelerAdditionalInfo = $travelerAdditionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAirReservationExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
