<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAirBookModifyRQExt StructType
 * Meta informations extracted from the WSDL
 * - documentation: AccelAero Extensions for OTA AirBookModifyRQ, which is included as TPA_Extension
 * @subpackage Structs
 */
class AAAirBookModifyRQExt extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - documentation: Reservation contact information
     * - minOccurs: 0
     * @var \StructType\AAContactInfoType
     */
    public $ContactInfo;
    /**
     * The UserNotes
     * Meta informations extracted from the WSDL
     * - documentation: Free Text Notes
     * - minOccurs: 0
     * @var \StructType\AAUserNotesType
     */
    public $UserNotes;
    /**
     * The AALoadDataOptions
     * Meta informations extracted from the WSDL
     * - documentation: Items to load in the response.
     * - minOccurs: 0
     * @var \StructType\AALoadDataOptionsType
     */
    public $AALoadDataOptions;
    /**
     * The CurrentExtPayTxInfo
     * Meta informations extracted from the WSDL
     * - documentation: External Payment Transaction Information.
     * - minOccurs: 0
     * @var \StructType\AAExternalPayTxType
     */
    public $CurrentExtPayTxInfo;
    /**
     * The AdminInfo
     * Meta informations extracted from the WSDL
     * - documentation: reservation Admin Information.
     * - minOccurs: 0
     * @var \StructType\AAAdminInfoType
     */
    public $AdminInfo;
    /**
     * The TravelerAdditionalInfo
     * Meta informations extracted from the WSDL
     * - documentation: Travellers Additional Information
     * - minOccurs: 0
     * @var \StructType\AATravelerInfoType
     */
    public $TravelerAdditionalInfo;
    /**
     * Constructor method for AAAirBookModifyRQExt
     * @uses AAAirBookModifyRQExt::setContactInfo()
     * @uses AAAirBookModifyRQExt::setUserNotes()
     * @uses AAAirBookModifyRQExt::setAALoadDataOptions()
     * @uses AAAirBookModifyRQExt::setCurrentExtPayTxInfo()
     * @uses AAAirBookModifyRQExt::setAdminInfo()
     * @uses AAAirBookModifyRQExt::setTravelerAdditionalInfo()
     * @param \StructType\AAContactInfoType $contactInfo
     * @param \StructType\AAUserNotesType $userNotes
     * @param \StructType\AALoadDataOptionsType $aALoadDataOptions
     * @param \StructType\AAExternalPayTxType $currentExtPayTxInfo
     * @param \StructType\AAAdminInfoType $adminInfo
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     */
    public function __construct(\StructType\AAContactInfoType $contactInfo = null, \StructType\AAUserNotesType $userNotes = null, \StructType\AALoadDataOptionsType $aALoadDataOptions = null, \StructType\AAExternalPayTxType $currentExtPayTxInfo = null, \StructType\AAAdminInfoType $adminInfo = null, \StructType\AATravelerInfoType $travelerAdditionalInfo = null)
    {
        $this
            ->setContactInfo($contactInfo)
            ->setUserNotes($userNotes)
            ->setAALoadDataOptions($aALoadDataOptions)
            ->setCurrentExtPayTxInfo($currentExtPayTxInfo)
            ->setAdminInfo($adminInfo)
            ->setTravelerAdditionalInfo($travelerAdditionalInfo);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\AAContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\AAContactInfoType $contactInfo
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setContactInfo(\StructType\AAContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get UserNotes value
     * @return \StructType\AAUserNotesType|null
     */
    public function getUserNotes()
    {
        return $this->UserNotes;
    }
    /**
     * Set UserNotes value
     * @param \StructType\AAUserNotesType $userNotes
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setUserNotes(\StructType\AAUserNotesType $userNotes = null)
    {
        $this->UserNotes = $userNotes;
        return $this;
    }
    /**
     * Get AALoadDataOptions value
     * @return \StructType\AALoadDataOptionsType|null
     */
    public function getAALoadDataOptions()
    {
        return $this->AALoadDataOptions;
    }
    /**
     * Set AALoadDataOptions value
     * @param \StructType\AALoadDataOptionsType $aALoadDataOptions
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setAALoadDataOptions(\StructType\AALoadDataOptionsType $aALoadDataOptions = null)
    {
        $this->AALoadDataOptions = $aALoadDataOptions;
        return $this;
    }
    /**
     * Get CurrentExtPayTxInfo value
     * @return \StructType\AAExternalPayTxType|null
     */
    public function getCurrentExtPayTxInfo()
    {
        return $this->CurrentExtPayTxInfo;
    }
    /**
     * Set CurrentExtPayTxInfo value
     * @param \StructType\AAExternalPayTxType $currentExtPayTxInfo
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setCurrentExtPayTxInfo(\StructType\AAExternalPayTxType $currentExtPayTxInfo = null)
    {
        $this->CurrentExtPayTxInfo = $currentExtPayTxInfo;
        return $this;
    }
    /**
     * Get AdminInfo value
     * @return \StructType\AAAdminInfoType|null
     */
    public function getAdminInfo()
    {
        return $this->AdminInfo;
    }
    /**
     * Set AdminInfo value
     * @param \StructType\AAAdminInfoType $adminInfo
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setAdminInfo(\StructType\AAAdminInfoType $adminInfo = null)
    {
        $this->AdminInfo = $adminInfo;
        return $this;
    }
    /**
     * Get TravelerAdditionalInfo value
     * @return \StructType\AATravelerInfoType|null
     */
    public function getTravelerAdditionalInfo()
    {
        return $this->TravelerAdditionalInfo;
    }
    /**
     * Set TravelerAdditionalInfo value
     * @param \StructType\AATravelerInfoType $travelerAdditionalInfo
     * @return \StructType\AAAirBookModifyRQExt
     */
    public function setTravelerAdditionalInfo(\StructType\AATravelerInfoType $travelerAdditionalInfo = null)
    {
        $this->TravelerAdditionalInfo = $travelerAdditionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAirBookModifyRQExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
