<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AAAgentSeatMovementsType StructType
 * @subpackage Structs
 */
class AAAgentSeatMovementsType extends AbstractStructBase
{
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The segmentCode
     * @var string
     */
    public $segmentCode;
    /**
     * The depatureDate
     * @var string
     */
    public $depatureDate;
    /**
     * The cabinClass
     * @var string
     */
    public $cabinClass;
    /**
     * The inventorySeatMovement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAAgentSeatMovementType[]
     */
    public $inventorySeatMovement;
    /**
     * Constructor method for AAAgentSeatMovementsType
     * @uses AAAgentSeatMovementsType::setFlightNumber()
     * @uses AAAgentSeatMovementsType::setSegmentCode()
     * @uses AAAgentSeatMovementsType::setDepatureDate()
     * @uses AAAgentSeatMovementsType::setCabinClass()
     * @uses AAAgentSeatMovementsType::setInventorySeatMovement()
     * @param string $flightNumber
     * @param string $segmentCode
     * @param string $depatureDate
     * @param string $cabinClass
     * @param \StructType\AAAgentSeatMovementType[] $inventorySeatMovement
     */
    public function __construct($flightNumber = null, $segmentCode = null, $depatureDate = null, $cabinClass = null, array $inventorySeatMovement = array())
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setSegmentCode($segmentCode)
            ->setDepatureDate($depatureDate)
            ->setCabinClass($cabinClass)
            ->setInventorySeatMovement($inventorySeatMovement);
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get segmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->segmentCode;
    }
    /**
     * Set segmentCode value
     * @param string $segmentCode
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->segmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get depatureDate value
     * @return string|null
     */
    public function getDepatureDate()
    {
        return $this->depatureDate;
    }
    /**
     * Set depatureDate value
     * @param string $depatureDate
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function setDepatureDate($depatureDate = null)
    {
        // validation for constraint: string
        if (!is_null($depatureDate) && !is_string($depatureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depatureDate)), __LINE__);
        }
        $this->depatureDate = $depatureDate;
        return $this;
    }
    /**
     * Get cabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->cabinClass;
    }
    /**
     * Set cabinClass value
     * @param string $cabinClass
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinClass)), __LINE__);
        }
        $this->cabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get inventorySeatMovement value
     * @return \StructType\AAAgentSeatMovementType[]|null
     */
    public function getInventorySeatMovement()
    {
        return $this->inventorySeatMovement;
    }
    /**
     * Set inventorySeatMovement value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAgentSeatMovementType[] $inventorySeatMovement
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function setInventorySeatMovement(array $inventorySeatMovement = array())
    {
        foreach ($inventorySeatMovement as $aAAgentSeatMovementsTypeInventorySeatMovementItem) {
            // validation for constraint: itemType
            if (!$aAAgentSeatMovementsTypeInventorySeatMovementItem instanceof \StructType\AAAgentSeatMovementType) {
                throw new \InvalidArgumentException(sprintf('The inventorySeatMovement property can only contain items of \StructType\AAAgentSeatMovementType, "%s" given', is_object($aAAgentSeatMovementsTypeInventorySeatMovementItem) ? get_class($aAAgentSeatMovementsTypeInventorySeatMovementItem) : gettype($aAAgentSeatMovementsTypeInventorySeatMovementItem)), __LINE__);
            }
        }
        $this->inventorySeatMovement = $inventorySeatMovement;
        return $this;
    }
    /**
     * Add item to inventorySeatMovement value
     * @throws \InvalidArgumentException
     * @param \StructType\AAAgentSeatMovementType $item
     * @return \StructType\AAAgentSeatMovementsType
     */
    public function addToInventorySeatMovement(\StructType\AAAgentSeatMovementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAAgentSeatMovementType) {
            throw new \InvalidArgumentException(sprintf('The inventorySeatMovement property can only contain items of \StructType\AAAgentSeatMovementType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->inventorySeatMovement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AAAgentSeatMovementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
