<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recon ServiceType
 * @subpackage Services
 */
class Recon extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reconPaymentTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AA_OTA_TransactionsReconRQ $aA_OTA_TransactionsReconRQ
     * @return \StructType\AA_OTA_TransactionsReconRS|bool
     */
    public function reconPaymentTransactions(\StructType\AA_OTA_TransactionsReconRQ $aA_OTA_TransactionsReconRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->reconPaymentTransactions($aA_OTA_TransactionsReconRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AA_OTA_TransactionsReconRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
