<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named modifyResQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirBookModifyRQ $oTA_AirBookModifyRQ
     * @param \StructType\AAAirBookModifyRQExt $aAAirBookModifyRQExt
     * @return \StructType\OTA_AirBookRS|bool
     */
    public function modifyResQuery(\StructType\OTA_AirBookModifyRQ $oTA_AirBookModifyRQ, \StructType\AAAirBookModifyRQExt $aAAirBookModifyRQExt)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyResQuery($oTA_AirBookModifyRQ, $aAAirBookModifyRQExt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirBookModifyRQ $oTA_AirBookModifyRQ
     * @param \StructType\AAAirBookModifyRQExt $aAAirBookModifyRQExt
     * @return \StructType\OTA_AirBookRS|bool
     */
    public function modifyReservation(\StructType\OTA_AirBookModifyRQ $oTA_AirBookModifyRQ, \StructType\AAAirBookModifyRQExt $aAAirBookModifyRQExt)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyReservation($oTA_AirBookModifyRQ, $aAAirBookModifyRQExt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_AirBookRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
