<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Book ServiceType
 * @subpackage Services
 */
class Book extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named book
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_AirBookRQ $oTA_AirBookRQ
     * @param \StructType\AAAirBookRQExt $aAAirBookRQExt
     * @return \StructType\OTA_AirBookRS|bool
     */
    public function book(\StructType\OTA_AirBookRQ $oTA_AirBookRQ, \StructType\AAAirBookRQExt $aAAirBookRQExt)
    {
        try {
            $this->setResult(self::getSoapClient()->book($oTA_AirBookRQ, $aAAirBookRQExt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_AirBookRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
