<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Batch ServiceType
 * @subpackage Services
 */
class Batch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named batchUpdateFlightInventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AAFlightInventryBatchUpdateRQ $aAFlightInvBatchUpdateRQ
     * @return \StructType\AAFlightInvBatchUpdateRS|bool
     */
    public function batchUpdateFlightInventory(\StructType\AAFlightInventryBatchUpdateRQ $aAFlightInvBatchUpdateRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->batchUpdateFlightInventory($aAFlightInvBatchUpdateRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AAFlightInvBatchUpdateRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
