<?php

namespace EnumType;

/**
 * This class stands for SSRType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: This defines a set of valid ssr service type can be request
 * @subpackage Enumerations
 */
class SSRType
{
    /**
     * Constant for value 'AIRPORT'
     * @return string 'AIRPORT'
     */
    const VALUE_AIRPORT = 'AIRPORT';
    /**
     * Constant for value 'INFLIGHT'
     * @return string 'INFLIGHT'
     */
    const VALUE_INFLIGHT = 'INFLIGHT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_INFLIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT,
            self::VALUE_INFLIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
