<?php

namespace EnumType;

/**
 * This class stands for Name EnumType
 * Meta informations extracted from the WSDL
 * - documentation: This name refers to an OTA Code List table (e.g. RestaurantCategoryCode/InfoCode). The actual code is passed in the Code attribute.
 * - type: StringLength1to64
 * - use: optional
 * @subpackage Enumerations
 */
class Name extends PersonNameType
{
    /**
     * Constant for value 'SrvcInfoCode'
     * @return string 'SrvcInfoCode'
     */
    const VALUE_SRVC_INFO_CODE = 'SrvcInfoCode';
    /**
     * Constant for value 'SrvcInfo'
     * @return string 'SrvcInfo'
     */
    const VALUE_SRVC_INFO = 'SrvcInfo';
    /**
     * Constant for value 'Beverage'
     * @return string 'Beverage'
     */
    const VALUE_BEVERAGE = 'Beverage';
    /**
     * Constant for value 'AvailableMealCategory'
     * @return string 'AvailableMealCategory'
     */
    const VALUE_AVAILABLE_MEAL_CATEGORY = 'AvailableMealCategory';
    /**
     * Constant for value 'RestaurantCategory'
     * @return string 'RestaurantCategory'
     */
    const VALUE_RESTAURANT_CATEGORY = 'RestaurantCategory';
    /**
     * Constant for value 'RestaurantPolicy'
     * @return string 'RestaurantPolicy'
     */
    const VALUE_RESTAURANT_POLICY = 'RestaurantPolicy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SRVC_INFO_CODE
     * @uses self::VALUE_SRVC_INFO
     * @uses self::VALUE_BEVERAGE
     * @uses self::VALUE_AVAILABLE_MEAL_CATEGORY
     * @uses self::VALUE_RESTAURANT_CATEGORY
     * @uses self::VALUE_RESTAURANT_POLICY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SRVC_INFO_CODE,
            self::VALUE_SRVC_INFO,
            self::VALUE_BEVERAGE,
            self::VALUE_AVAILABLE_MEAL_CATEGORY,
            self::VALUE_RESTAURANT_CATEGORY,
            self::VALUE_RESTAURANT_POLICY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
