<?php

namespace EnumType;

/**
 * This class stands for EntryStatus EnumType
 * @subpackage Enumerations
 */
class EntryStatus
{
    /**
     * Constant for value 'GO_SHORE'
     * @return string 'GO_SHORE'
     */
    const VALUE_GO_SHORE = 'GO_SHORE';
    /**
     * Constant for value 'NO_SHORE'
     * @return string 'NO_SHORE'
     */
    const VALUE_NO_SHORE = 'NO_SHORE';
    /**
     * Constant for value 'NO_REC'
     * @return string 'NO_REC'
     */
    const VALUE_NO_REC = 'NO_REC';
    /**
     * Constant for value 'OFF_LD'
     * @return string 'OFF_LD'
     */
    const VALUE_OFF_LD = 'OFF_LD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GO_SHORE
     * @uses self::VALUE_NO_SHORE
     * @uses self::VALUE_NO_REC
     * @uses self::VALUE_OFF_LD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GO_SHORE,
            self::VALUE_NO_SHORE,
            self::VALUE_NO_REC,
            self::VALUE_OFF_LD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
