<?php

namespace EnumType;

/**
 * This class stands for ETicketStatusUpdateType EnumType
 * @subpackage Enumerations
 */
class ETicketStatusUpdateType
{
    /**
     * Constant for value 'CHECKEDIN'
     * @return string 'CHECKEDIN'
     */
    const VALUE_CHECKEDIN = 'CHECKEDIN';
    /**
     * Constant for value 'BOARDED'
     * @return string 'BOARDED'
     */
    const VALUE_BOARDED = 'BOARDED';
    /**
     * Constant for value 'OPEN'
     * @return string 'OPEN'
     */
    const VALUE_OPEN = 'OPEN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECKEDIN
     * @uses self::VALUE_BOARDED
     * @uses self::VALUE_OPEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECKEDIN,
            self::VALUE_BOARDED,
            self::VALUE_OPEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
