<?php

namespace EnumType;

/**
 * This class stands for ETicketStatusType EnumType
 * @subpackage Enumerations
 */
class ETicketStatusType
{
    /**
     * Constant for value 'Z'
     * @return string 'Z'
     */
    const VALUE_Z = 'Z';
    /**
     * Constant for value 'O'
     * @return string 'O'
     */
    const VALUE_O = 'O';
    /**
     * Constant for value 'F'
     * @return string 'F'
     */
    const VALUE_F = 'F';
    /**
     * Constant for value 'V'
     * @return string 'V'
     */
    const VALUE_V = 'V';
    /**
     * Constant for value 'L'
     * @return string 'L'
     */
    const VALUE_L = 'L';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'X'
     * @return string 'X'
     */
    const VALUE_X = 'X';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_Z
     * @uses self::VALUE_O
     * @uses self::VALUE_F
     * @uses self::VALUE_V
     * @uses self::VALUE_L
     * @uses self::VALUE_C
     * @uses self::VALUE_E
     * @uses self::VALUE_S
     * @uses self::VALUE_X
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Z,
            self::VALUE_O,
            self::VALUE_F,
            self::VALUE_V,
            self::VALUE_L,
            self::VALUE_C,
            self::VALUE_E,
            self::VALUE_S,
            self::VALUE_X,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
