<?php

namespace EnumType;

/**
 * This class stands for CabinType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: A cabin is either First, Business or Economy
 * @subpackage Enumerations
 */
class CabinType
{
    /**
     * Constant for value 'F'
     * @return string 'F'
     */
    const VALUE_F = 'F';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'J'
     * @return string 'J'
     */
    const VALUE_J = 'J';
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_F
     * @uses self::VALUE_C
     * @uses self::VALUE_J
     * @uses self::VALUE_Y
     * @uses self::VALUE_W
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_F,
            self::VALUE_C,
            self::VALUE_J,
            self::VALUE_Y,
            self::VALUE_W,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
