<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://reservations.mahan.aero/webservices/services/AAResWebServices?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://reservations.mahan.aero/webservices/services/AAResWebServices?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getSeatMap operation/method
 */
if ($get->getSeatMap(new \StructType\OTA_AirSeatMapRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIOBoundPaxCountInfo operation/method
 */
if ($get->getIOBoundPaxCountInfo(new \StructType\AAFligthtLegPaxCountInfoRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPaxTypesForFlightLeg operation/method
 */
if ($get->getPaxTypesForFlightLeg(new \StructType\AAFligthtLegPaxCountInfoRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReservationbyPNR operation/method
 */
if ($get->getReservationbyPNR(new \StructType\OTA_ReadRQ(), new \StructType\AAReadRQExt()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAgentSeatSellingReport operation/method
 */
if ($get->getAgentSeatSellingReport(new \StructType\AAAgentSeatMovemantRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAvailability operation/method
 */
if ($get->getAvailability(new \StructType\OTA_AirAvailRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTermsNConditions operation/method
 */
if ($get->getTermsNConditions(new \StructType\AA_OTA_TermsNConditionsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getResAuditHistory operation/method
 */
if ($get->getResAuditHistory(new \StructType\AA_OTA_ResAuditReadRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFlightInventoryAllocations operation/method
 */
if ($get->getFlightInventoryAllocations(new \StructType\AAFlightInventorySearchRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInsuranceQuote operation/method
 */
if ($get->getInsuranceQuote(new \StructType\OTA_InsuranceQuoteRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSSRDetails operation/method
 */
if ($get->getSSRDetails(new \StructType\AA_OTA_AirSSRDetailsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMealDetails operation/method
 */
if ($get->getMealDetails(new \StructType\AA_OTA_AirMealDetailsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFlightInfo operation/method
 */
if ($get->getFlightInfo(new \StructType\OTA_AirFlifoRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAgentSalesData operation/method
 */
if ($get->getAgentSalesData(new \StructType\AAPNRPaxTicketingDataRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFlightSchedule operation/method
 */
if ($get->getFlightSchedule(new \StructType\OTA_AirScheduleRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrice operation/method
 */
if ($get->getPrice(new \StructType\OTA_AirPriceRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAgentAvailableCredit operation/method
 */
if ($get->getAgentAvailableCredit(new \StructType\AA_OTA_AgentAvailCreditRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPassengerCredit operation/method
 */
if ($get->getPassengerCredit(new \StructType\AA_OTA_PaxCreditReadRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReservationsList operation/method
 */
if ($get->getReservationsList(new \StructType\OTA_ReadRQ(), new \StructType\AAReadRQExt()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFlightLoadInfo operation/method
 */
if ($get->getFlightLoadInfo(new \StructType\AAFlightLoadInfoRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getItinerary operation/method
 */
if ($get->getItinerary(new \StructType\OTA_ReadRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBaggageDetails operation/method
 */
if ($get->getBaggageDetails(new \StructType\AA_OTA_AirBaggageDetailsRQ()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateEticketStatus operation/method
 */
if ($update->updateEticketStatus(new \StructType\AA_OTA_ETicketStatusUpdateRQ()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateOptimizedInventory operation/method
 */
if ($update->updateOptimizedInventory(new \StructType\AAUpdateOptimizedInventoryRQ()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePFS operation/method
 */
if ($update->updatePFS(new \StructType\AA_OTA_PFSUpdateRQ()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for ping operation/method
 */
if ($ping->ping(new \StructType\OTA_PingRQ()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \ServiceType\Book($options);
/**
 * Sample call for book operation/method
 */
if ($book->book(new \StructType\OTA_AirBookRQ(), new \StructType\AAAirBookRQExt()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Batch ServiceType
 */
$batch = new \ServiceType\Batch($options);
/**
 * Sample call for batchUpdateFlightInventory operation/method
 */
if ($batch->batchUpdateFlightInventory(new \StructType\AAFlightInventryBatchUpdateRQ()) !== false) {
    print_r($batch->getResult());
} else {
    print_r($batch->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for modifyResQuery operation/method
 */
if ($modify->modifyResQuery(new \StructType\OTA_AirBookModifyRQ(), new \StructType\AAAirBookModifyRQExt()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyReservation operation/method
 */
if ($modify->modifyReservation(new \StructType\OTA_AirBookModifyRQ(), new \StructType\AAAirBookModifyRQExt()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Recon ServiceType
 */
$recon = new \ServiceType\Recon($options);
/**
 * Sample call for reconPaymentTransactions operation/method
 */
if ($recon->reconPaymentTransactions(new \StructType\AA_OTA_TransactionsReconRQ()) !== false) {
    print_r($recon->getResult());
} else {
    print_r($recon->getLastError());
}
/**
 * Samples for Manual ServiceType
 */
$manual = new \ServiceType\Manual($options);
/**
 * Sample call for manualSendEBIDailyReconRpt operation/method
 */
if ($manual->manualSendEBIDailyReconRpt(new \StructType\AA_OTA_EBIManualDailyReconRptSendRQ()) !== false) {
    print_r($manual->getResult());
} else {
    print_r($manual->getLastError());
}
/**
 * Samples for Sync ServiceType
 */
$sync = new \ServiceType\Sync($options);
/**
 * Sample call for syncPnrTxnsWithEBI operation/method
 */
if ($sync->syncPnrTxnsWithEBI(new \StructType\AA_OTA_EBIPnrTxnsReconRQ()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
