<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerFulfillments StructType
 * Meta informations extracted from the WSDL
 * - documentation: Traveler fulfillments details.
 * @subpackage Structs
 */
class TravelerFulfillments extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - documentation: Form of Traveler wise payment details for the requested booking. It is possible to use multiple forms of payment for one transaction, therefore this element may be used more than once.
     * - maxOccurs: 2
     * @var mixed[]
     */
    public $PaymentDetail;
    /**
     * The TravelerRefNumberRPH
     * @var string
     */
    public $TravelerRefNumberRPH;
    /**
     * Constructor method for TravelerFulfillments
     * @uses TravelerFulfillments::setPaymentDetail()
     * @uses TravelerFulfillments::setTravelerRefNumberRPH()
     * @param mixed[] $paymentDetail
     * @param string $travelerRefNumberRPH
     */
    public function __construct(array $paymentDetail = array(), $travelerRefNumberRPH = null)
    {
        $this
            ->setPaymentDetail($paymentDetail)
            ->setTravelerRefNumberRPH($travelerRefNumberRPH);
    }
    /**
     * Get PaymentDetail value
     * @return mixed[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentDetail
     * @return \StructType\TravelerFulfillments
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        foreach ($paymentDetail as $travelerFulfillmentsPaymentDetailItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of anyType, "%s" given', is_object($travelerFulfillmentsPaymentDetailItem) ? get_class($travelerFulfillmentsPaymentDetailItem) : gettype($travelerFulfillmentsPaymentDetailItem)), __LINE__);
            }
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\TravelerFulfillments
     */
    public function addToPaymentDetail($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPH value
     * @return string|null
     */
    public function getTravelerRefNumberRPH()
    {
        return $this->TravelerRefNumberRPH;
    }
    /**
     * Set TravelerRefNumberRPH value
     * @param string $travelerRefNumberRPH
     * @return \StructType\TravelerFulfillments
     */
    public function setTravelerRefNumberRPH($travelerRefNumberRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumberRPH) && !is_string($travelerRefNumberRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumberRPH)), __LINE__);
        }
        $this->TravelerRefNumberRPH = $travelerRefNumberRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerFulfillments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
