<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Minimum information about ticketing required to complete the booking transaction.
 * @subpackage Structs
 */
class TicketingInfoType extends AbstractStructBase
{
    /**
     * The TicketType
     * Meta informations extracted from the WSDL
     * - documentation: TicketType - Indicates the type of ticket (Paper, eTicket)
     * - use: required
     * @var string
     */
    public $TicketType;
    /**
     * The TicketAdvisory
     * Meta informations extracted from the WSDL
     * - documentation: Open text field available for additional ticket information.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TicketAdvisory;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The TicketingStatus
     * Meta informations extracted from the WSDL
     * - documentation: Code for setting and displaying detailed ticketing information. Refer to OTA Code List Ticketing Status (TST).
     * - use: optional
     * @var string
     */
    public $TicketingStatus;
    /**
     * The FlightSegmentRefNumber
     * Meta informations extracted from the WSDL
     * - documentation: Specifies one or more segment numbers for ticketing purposes. This RPH is associated with the RPH contained in the FlightSegment element in AirBookRQ.
     * - use: optional
     * @var string
     */
    public $FlightSegmentRefNumber;
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - documentation: Specifies one or more traveler names for ticketing purposes. This RPH is associated with the RPH contained in the TravelerRefNumber element in AirBookRQ.
     * - use: optional
     * @var string
     */
    public $TravelerRefNumber;
    /**
     * The ReverseTktgSegmentsInd
     * Meta informations extracted from the WSDL
     * - documentation: Applies a reverse sequence of the outbound travel to the inbound travel.
     * - use: optional
     * @var bool
     */
    public $ReverseTktgSegmentsInd;
    /**
     * Constructor method for TicketingInfoType
     * @uses TicketingInfoType::setTicketType()
     * @uses TicketingInfoType::setTicketAdvisory()
     * @uses TicketingInfoType::setTicketTimeLimit()
     * @uses TicketingInfoType::setTicketingStatus()
     * @uses TicketingInfoType::setFlightSegmentRefNumber()
     * @uses TicketingInfoType::setTravelerRefNumber()
     * @uses TicketingInfoType::setReverseTktgSegmentsInd()
     * @param string $ticketType
     * @param mixed[] $ticketAdvisory
     * @param string $ticketTimeLimit
     * @param string $ticketingStatus
     * @param string $flightSegmentRefNumber
     * @param string $travelerRefNumber
     * @param bool $reverseTktgSegmentsInd
     */
    public function __construct($ticketType = null, array $ticketAdvisory = array(), $ticketTimeLimit = null, $ticketingStatus = null, $flightSegmentRefNumber = null, $travelerRefNumber = null, $reverseTktgSegmentsInd = null)
    {
        $this
            ->setTicketType($ticketType)
            ->setTicketAdvisory($ticketAdvisory)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setTicketingStatus($ticketingStatus)
            ->setFlightSegmentRefNumber($flightSegmentRefNumber)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setReverseTktgSegmentsInd($reverseTktgSegmentsInd);
    }
    /**
     * Get TicketType value
     * @return string
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param string $ticketType
     * @return \StructType\TicketingInfoType
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketType) && !is_string($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketType)), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketAdvisory value
     * @return mixed[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * Set TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketAdvisory
     * @return \StructType\TicketingInfoType
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        foreach ($ticketAdvisory as $ticketingInfoTypeTicketAdvisoryItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of anyType, "%s" given', is_object($ticketingInfoTypeTicketAdvisoryItem) ? get_class($ticketingInfoTypeTicketAdvisoryItem) : gettype($ticketingInfoTypeTicketAdvisoryItem)), __LINE__);
            }
        }
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\TicketingInfoType
     */
    public function addToTicketAdvisory($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \StructType\TicketingInfoType
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTimeLimit) && !is_string($ticketTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketTimeLimit)), __LINE__);
        }
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get TicketingStatus value
     * @return string|null
     */
    public function getTicketingStatus()
    {
        return $this->TicketingStatus;
    }
    /**
     * Set TicketingStatus value
     * @param string $ticketingStatus
     * @return \StructType\TicketingInfoType
     */
    public function setTicketingStatus($ticketingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingStatus) && !is_string($ticketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketingStatus)), __LINE__);
        }
        $this->TicketingStatus = $ticketingStatus;
        return $this;
    }
    /**
     * Get FlightSegmentRefNumber value
     * @return string|null
     */
    public function getFlightSegmentRefNumber()
    {
        return $this->FlightSegmentRefNumber;
    }
    /**
     * Set FlightSegmentRefNumber value
     * @param string $flightSegmentRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setFlightSegmentRefNumber($flightSegmentRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightSegmentRefNumber) && !is_string($flightSegmentRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightSegmentRefNumber)), __LINE__);
        }
        $this->FlightSegmentRefNumber = $flightSegmentRefNumber;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return string|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param string $travelerRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setTravelerRefNumber($travelerRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumber) && !is_string($travelerRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumber)), __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get ReverseTktgSegmentsInd value
     * @return bool|null
     */
    public function getReverseTktgSegmentsInd()
    {
        return $this->ReverseTktgSegmentsInd;
    }
    /**
     * Set ReverseTktgSegmentsInd value
     * @param bool $reverseTktgSegmentsInd
     * @return \StructType\TicketingInfoType
     */
    public function setReverseTktgSegmentsInd($reverseTktgSegmentsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseTktgSegmentsInd) && !is_bool($reverseTktgSegmentsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reverseTktgSegmentsInd)), __LINE__);
        }
        $this->ReverseTktgSegmentsInd = $reverseTktgSegmentsInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
