<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Telephone StructType
 * Meta informations extracted from the WSDL
 * - documentation: Request a reservation based on a telephone number. | The first and last dates between which this telephone number is in effect. | Telephone number(s) used in the search. | Telephone number for the person traveling. | Identifies a
 * telephone number for the traveler.
 * @subpackage Structs
 */
class Telephone extends TelephoneInfoType
{
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: A 3 character ATA/IATA city code of telephone location.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * Constructor method for Telephone
     * @uses Telephone::setOperation()
     * @uses Telephone::setLocationCode()
     * @param string $operation
     * @param string $locationCode
     */
    public function __construct($operation = null, $locationCode = null)
    {
        $this
            ->setOperation($operation)
            ->setLocationCode($locationCode);
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param string $operation
     * @return \StructType\Telephone
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\Telephone
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Telephone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
