<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialReqDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Remarks, OSIs, Seat Requests etc.
 * @subpackage Structs
 */
class SpecialReqDetailsType extends AbstractStructBase
{
    /**
     * The SeatRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SeatRequests
     */
    public $SeatRequests;
    /**
     * The SpecialServiceRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialServiceRequests
     */
    public $SpecialServiceRequests;
    /**
     * The MealRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealRequests
     */
    public $MealRequests;
    /**
     * The SSRRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SSRRequests
     */
    public $SSRRequests;
    /**
     * The BaggageRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaggageRequests
     */
    public $BaggageRequests;
    /**
     * The InsuranceRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InsuranceRequests
     */
    public $InsuranceRequests;
    /**
     * The OtherServiceInformations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherServiceInformations
     */
    public $OtherServiceInformations;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Remarks
     */
    public $Remarks;
    /**
     * The SpecialRemarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialRemarks
     */
    public $SpecialRemarks;
    /**
     * Constructor method for SpecialReqDetailsType
     * @uses SpecialReqDetailsType::setSeatRequests()
     * @uses SpecialReqDetailsType::setSpecialServiceRequests()
     * @uses SpecialReqDetailsType::setMealRequests()
     * @uses SpecialReqDetailsType::setSSRRequests()
     * @uses SpecialReqDetailsType::setBaggageRequests()
     * @uses SpecialReqDetailsType::setInsuranceRequests()
     * @uses SpecialReqDetailsType::setOtherServiceInformations()
     * @uses SpecialReqDetailsType::setRemarks()
     * @uses SpecialReqDetailsType::setSpecialRemarks()
     * @param \StructType\SeatRequests $seatRequests
     * @param \StructType\SpecialServiceRequests $specialServiceRequests
     * @param \StructType\MealRequests $mealRequests
     * @param \StructType\SSRRequests $sSRRequests
     * @param \StructType\BaggageRequests $baggageRequests
     * @param \StructType\InsuranceRequests $insuranceRequests
     * @param \StructType\OtherServiceInformations $otherServiceInformations
     * @param \StructType\Remarks $remarks
     * @param \StructType\SpecialRemarks $specialRemarks
     */
    public function __construct(\StructType\SeatRequests $seatRequests = null, \StructType\SpecialServiceRequests $specialServiceRequests = null, \StructType\MealRequests $mealRequests = null, \StructType\SSRRequests $sSRRequests = null, \StructType\BaggageRequests $baggageRequests = null, \StructType\InsuranceRequests $insuranceRequests = null, \StructType\OtherServiceInformations $otherServiceInformations = null, \StructType\Remarks $remarks = null, \StructType\SpecialRemarks $specialRemarks = null)
    {
        $this
            ->setSeatRequests($seatRequests)
            ->setSpecialServiceRequests($specialServiceRequests)
            ->setMealRequests($mealRequests)
            ->setSSRRequests($sSRRequests)
            ->setBaggageRequests($baggageRequests)
            ->setInsuranceRequests($insuranceRequests)
            ->setOtherServiceInformations($otherServiceInformations)
            ->setRemarks($remarks)
            ->setSpecialRemarks($specialRemarks);
    }
    /**
     * Get SeatRequests value
     * @return \StructType\SeatRequests|null
     */
    public function getSeatRequests()
    {
        return $this->SeatRequests;
    }
    /**
     * Set SeatRequests value
     * @param \StructType\SeatRequests $seatRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSeatRequests(\StructType\SeatRequests $seatRequests = null)
    {
        $this->SeatRequests = $seatRequests;
        return $this;
    }
    /**
     * Get SpecialServiceRequests value
     * @return \StructType\SpecialServiceRequests|null
     */
    public function getSpecialServiceRequests()
    {
        return $this->SpecialServiceRequests;
    }
    /**
     * Set SpecialServiceRequests value
     * @param \StructType\SpecialServiceRequests $specialServiceRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSpecialServiceRequests(\StructType\SpecialServiceRequests $specialServiceRequests = null)
    {
        $this->SpecialServiceRequests = $specialServiceRequests;
        return $this;
    }
    /**
     * Get MealRequests value
     * @return \StructType\MealRequests|null
     */
    public function getMealRequests()
    {
        return $this->MealRequests;
    }
    /**
     * Set MealRequests value
     * @param \StructType\MealRequests $mealRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setMealRequests(\StructType\MealRequests $mealRequests = null)
    {
        $this->MealRequests = $mealRequests;
        return $this;
    }
    /**
     * Get SSRRequests value
     * @return \StructType\SSRRequests|null
     */
    public function getSSRRequests()
    {
        return $this->SSRRequests;
    }
    /**
     * Set SSRRequests value
     * @param \StructType\SSRRequests $sSRRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSSRRequests(\StructType\SSRRequests $sSRRequests = null)
    {
        $this->SSRRequests = $sSRRequests;
        return $this;
    }
    /**
     * Get BaggageRequests value
     * @return \StructType\BaggageRequests|null
     */
    public function getBaggageRequests()
    {
        return $this->BaggageRequests;
    }
    /**
     * Set BaggageRequests value
     * @param \StructType\BaggageRequests $baggageRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setBaggageRequests(\StructType\BaggageRequests $baggageRequests = null)
    {
        $this->BaggageRequests = $baggageRequests;
        return $this;
    }
    /**
     * Get InsuranceRequests value
     * @return \StructType\InsuranceRequests|null
     */
    public function getInsuranceRequests()
    {
        return $this->InsuranceRequests;
    }
    /**
     * Set InsuranceRequests value
     * @param \StructType\InsuranceRequests $insuranceRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setInsuranceRequests(\StructType\InsuranceRequests $insuranceRequests = null)
    {
        $this->InsuranceRequests = $insuranceRequests;
        return $this;
    }
    /**
     * Get OtherServiceInformations value
     * @return \StructType\OtherServiceInformations|null
     */
    public function getOtherServiceInformations()
    {
        return $this->OtherServiceInformations;
    }
    /**
     * Set OtherServiceInformations value
     * @param \StructType\OtherServiceInformations $otherServiceInformations
     * @return \StructType\SpecialReqDetailsType
     */
    public function setOtherServiceInformations(\StructType\OtherServiceInformations $otherServiceInformations = null)
    {
        $this->OtherServiceInformations = $otherServiceInformations;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\Remarks|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\Remarks $remarks
     * @return \StructType\SpecialReqDetailsType
     */
    public function setRemarks(\StructType\Remarks $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SpecialRemarks value
     * @return \StructType\SpecialRemarks|null
     */
    public function getSpecialRemarks()
    {
        return $this->SpecialRemarks;
    }
    /**
     * Set SpecialRemarks value
     * @param \StructType\SpecialRemarks $specialRemarks
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSpecialRemarks(\StructType\SpecialRemarks $specialRemarks = null)
    {
        $this->SpecialRemarks = $specialRemarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialReqDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
